/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.internal.filesystem;

import com.microsoft.tfs.jni.FileSystem;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.loader.NativeLoader;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeFileSystem
implements FileSystem {
    private static final Object umaskLock;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystemAttributes getAttributes(String filepath) {
        FileSystemAttributes fileSystemAttributes;
        Check.notNull(filepath, "filepath");
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("ENTER getAttributes({0})", filepath));
        }
        try {
            fileSystemAttributes = NativeFileSystem.nativeGetAttributes(filepath);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT getAttributes({0})", filepath));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("EXIT getAttributes({0})", filepath));
        }
        return fileSystemAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setAttributes(String filepath, FileSystemAttributes attributes) {
        boolean bl;
        Check.notNull(filepath, "filepath");
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("ENTER setAttributes({0}, {1})", filepath, attributes));
        }
        try {
            Object object = umaskLock;
            synchronized (object) {
                bl = NativeFileSystem.nativeSetAttributes(filepath, attributes);
            }
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT setAttributes({0}, {1})", filepath, attributes));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("EXIT setAttributes({0}, {1})", filepath, attributes));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOwner(String path) {
        String string;
        Check.notNull(path, "path");
        if (!Platform.isCurrentPlatform(Platform.WINDOWS)) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("ENTER getOwner({0})", path));
        }
        try {
            string = NativeFileSystem.nativeGetOwner(path);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT getOwner({0})", path));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("EXIT getOwner({0})", path));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOwner(String path, String owner) {
        Check.notNull(path, "path");
        Check.notNull(owner, "owner");
        if (!Platform.isCurrentPlatform(Platform.WINDOWS)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("ENTER setOwner({0}, {1})", path, owner));
        }
        try {
            NativeFileSystem.nativeSetOwner(path, owner);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT setOwner({0}, {1})", path, owner));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("EXIT setOwner({0}, {1})", path, owner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantInheritableFullControl(String path, String user, String copyExplicitRulesFromPath) {
        if (!Platform.isCurrentPlatform(Platform.WINDOWS)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("ENTER grantInheritableFullControl({0}, {1}, {2})", path, user, copyExplicitRulesFromPath));
        }
        try {
            NativeFileSystem.nativeGrantInheritableFullControl(path, user, copyExplicitRulesFromPath);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT grantInheritableFullControl({0}, {1}, {2})", path, user, copyExplicitRulesFromPath));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("EXIT grantInheritableFullControl({0}, {1}, {2})", path, user, copyExplicitRulesFromPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyExplicitDACLEntries(String sourcePath, String targetPath) {
        if (!Platform.isCurrentPlatform(Platform.WINDOWS)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("ENTER copyExplicitDACLs({0}, {1})", sourcePath, targetPath));
        }
        try {
            NativeFileSystem.nativeCopyExplicitDACLEntries(sourcePath, targetPath);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT copyExplicitDACLs({0}, {1})", sourcePath, targetPath));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("EXIT copyExplicitDACLs({0}, {1})", sourcePath, targetPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExplicitAllowEntries(String path, String user) {
        if (!Platform.isCurrentPlatform(Platform.WINDOWS)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("ENTER removeExplicitAllowEntries({0}, {1})", path, user));
        }
        try {
            NativeFileSystem.nativeRemoveExplicitAllowEntries(path, user);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT removeExplicitAllowEntries({0}, {1})", path, user));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("EXIT removeExplicitAllowEntries({0}, {1})", path, user));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createSymbolicLink(String oldpath, String newpath) {
        boolean bl;
        Check.notNull(oldpath, "oldpath");
        Check.notNull(newpath, "newpath");
        if (!Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("ENTER createSymbolicLink({0}, {1})", oldpath, newpath));
        }
        try {
            boolean bl2 = bl = NativeFileSystem.nativeCreateSymbolicLink(oldpath, newpath) == 0;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT createSymbolicLink({0}, {1})", oldpath, newpath));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("EXIT createSymbolicLink({0}, {1})", oldpath, newpath));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSymbolicLink(String path) {
        String string;
        Check.notNull(path, "path");
        if (!Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("ENTER getSymbolicLink({0})", path));
        }
        try {
            string = NativeFileSystem.nativeGetSymbolicLink(path);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT getSymbolicLink({0})", path));
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("EXIT getSymbolicLink({0})", path));
        }
        return string;
    }

    public File createTempFileSecure(String prefix, String suffix) throws IOException {
        return this.createTempFileSecure(prefix, suffix, null);
    }

    public File createTempFileSecure(String prefix, String suffix, File directory) throws IOException {
        if (!Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
            return File.createTempFile(prefix, suffix, directory);
        }
        Check.notNull(prefix, "prefix");
        Check.isTrue(prefix.length() >= 3, "prefix.length() >= 3");
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (directory == null) {
            String tempPath = System.getProperty("java.io.tmpdir");
            if (tempPath == null) {
                throw new IOException("Could not determine temporary directory");
            }
            directory = new File(tempPath);
            Check.isTrue(directory.isDirectory(), "directory.isDirectory()");
        }
        String filename = NativeFileSystem.nativeCreateTempFileSecure(prefix, suffix, directory.getAbsolutePath());
        Check.notNull(filename, "filename");
        return new File(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listMacExtendedAttributes(String filepath) {
        Check.notNull(filepath, "filepath");
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            String[] stringArray;
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("ENTER listMacExtendedAttributes({0})", filepath));
            }
            try {
                stringArray = NativeFileSystem.nativeListMacExtendedAttributes(filepath);
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)MessageFormat.format("EXIT listMacExtendedAttributes({0})", filepath));
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT listMacExtendedAttributes({0})", filepath));
            }
            return stringArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readMacExtendedAttribute(String filepath, String attribute2, byte[] buffer, int size, long position) {
        Check.notNull(filepath, "filepath");
        Check.notNull(attribute2, "attribute");
        Check.notNull(buffer, "buffer");
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            int n;
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("ENTER readMacExtendedAttribute({0}, {1}, ..., {2}, {3})", filepath, attribute2, size, position));
            }
            try {
                n = NativeFileSystem.nativeReadMacExtendedAttribute(filepath, attribute2, buffer, size, position);
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)MessageFormat.format("EXIT readMacExtendedAttribute({0}, {1}, ..., {2}, {3})", filepath, attribute2, size, position));
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT readMacExtendedAttribute({0}, {1}, ..., {2}, {3})", filepath, attribute2, size, position));
            }
            return n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeMacExtendedAttribute(String filepath, String attribute2, byte[] buffer, int size, long position) {
        Check.notNull(filepath, "filepath");
        Check.notNull(attribute2, "attribute");
        Check.notNull(buffer, "buffer");
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            boolean bl;
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("ENTER writeMacExtendedAttribute({0}, {1}, ..., {2}, {3})", filepath, attribute2, size, position));
            }
            try {
                bl = NativeFileSystem.nativeWriteMacExtendedAttribute(filepath, attribute2, buffer, size, position);
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)MessageFormat.format("EXIT writeMacExtendedAttribute({0}, {1}, ..., {2}, {3})", filepath, attribute2, size, position));
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT writeMacExtendedAttribute({0}, {1}, ..., {2}, {3})", filepath, attribute2, size, position));
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getMacExtendedAttribute(String filepath, String attribute2) {
        Check.notNull(filepath, "filepath");
        Check.notNull(attribute2, "attribute");
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            byte[] byArray;
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("ENTER getMacExtendedAttribute({0}, {1})", filepath, attribute2));
            }
            try {
                byArray = NativeFileSystem.nativeGetMacExtendedAttribute(filepath, attribute2);
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)MessageFormat.format("EXIT getMacExtendedAttribute({0}, {1})", filepath, attribute2));
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT getMacExtendedAttribute({0}, {1})", filepath, attribute2));
            }
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setMacExtendedAttribute(String filepath, String attribute2, byte[] value) {
        Check.notNull(filepath, "filepath");
        Check.notNull(attribute2, "attribute");
        Check.notNull(value, "value");
        if (Platform.isCurrentPlatform(Platform.MAC_OS_X)) {
            boolean bl;
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("ENTER setMacExtendedAttribute({0}, {1}, ...)", filepath, attribute2));
            }
            try {
                bl = NativeFileSystem.nativeSetMacExtendedAttribute(filepath, attribute2, value);
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)MessageFormat.format("EXIT setMacExtendedAttribute({0}, {1}, ...)", filepath, attribute2));
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("EXIT setMacExtendedAttribute({0}, {1}, ...)", filepath, attribute2));
            }
            return bl;
        }
        return false;
    }

    private static native FileSystemAttributes nativeGetAttributes(String var0);

    private static native boolean nativeSetAttributes(String var0, FileSystemAttributes var1);

    private static native String nativeGetOwner(String var0);

    private static native void nativeSetOwner(String var0, String var1);

    private static native void nativeGrantInheritableFullControl(String var0, String var1, String var2);

    private static native void nativeCopyExplicitDACLEntries(String var0, String var1);

    private static native void nativeRemoveExplicitAllowEntries(String var0, String var1);

    private static native String nativeCreateTempFileSecure(String var0, String var1, String var2);

    private static native int nativeCreateSymbolicLink(String var0, String var1);

    private static native String nativeGetSymbolicLink(String var0);

    private static native String[] nativeListMacExtendedAttributes(String var0);

    private static native int nativeReadMacExtendedAttribute(String var0, String var1, byte[] var2, int var3, long var4);

    private static native boolean nativeWriteMacExtendedAttribute(String var0, String var1, byte[] var2, int var3, long var4);

    private static native byte[] nativeGetMacExtendedAttribute(String var0, String var1);

    private static native boolean nativeSetMacExtendedAttribute(String var0, String var1, byte[] var2);

    static {
        NativeLoader.loadLibraryAndLogError("native_filesystem");
        umaskLock = new Object();
        log = LogFactory.getLog(NativeFileSystem.class);
    }
}

