/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.htmlfilter;

import java.util.Map;
import java.util.TreeMap;

class AllowedHTMLTags {
    private static Map<String, TagInfo> m_hashAllowed;
    private static Map<String, Integer> m_hashSpecial;
    private static Map<String, Integer> m_hashAttributes;

    AllowedHTMLTags() {
    }

    public static boolean areTagsEqual(String t1, String t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 != null) {
            return t1.equalsIgnoreCase(t2);
        }
        return false;
    }

    public static boolean isAllowedTag(String s) {
        AllowedHTMLTags.init();
        return m_hashAllowed.containsKey(s);
    }

    public static boolean isSpecialTag(String s) {
        AllowedHTMLTags.init();
        return m_hashSpecial.containsKey(s);
    }

    public static boolean isAllowedAttribute(String t, String a) {
        AllowedHTMLTags.init();
        if (m_hashAttributes.containsKey(a)) {
            return true;
        }
        if (m_hashAllowed.containsKey(t)) {
            TagInfo ti = m_hashAllowed.get(t);
            return ti.m_attributes != null && ti.m_attributes.containsKey(a);
        }
        return false;
    }

    public static int getEOLBefore(String t) {
        AllowedHTMLTags.init();
        if (m_hashAllowed.containsKey(t)) {
            TagInfo ti = m_hashAllowed.get(t);
            return ti.m_eolBefore;
        }
        return 0;
    }

    public static int getEOLAfter(String t) {
        AllowedHTMLTags.init();
        if (m_hashAllowed.containsKey(t)) {
            TagInfo ti = m_hashAllowed.get(t);
            return ti.m_eolAfter;
        }
        return 0;
    }

    private static void addTag(String tag, int eolBefore, int eolAfter, String[] attributes) {
        if (attributes == null) {
            m_hashAllowed.put(tag, new TagInfo());
        } else {
            TagInfo ti = new TagInfo();
            ti.m_eolBefore = eolBefore;
            ti.m_eolAfter = eolAfter;
            ti.m_attributes = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            for (String s : attributes) {
                ti.m_attributes.put(s, 0);
            }
            m_hashAllowed.put(tag, ti);
        }
    }

    private static void addTag(String tag, String[] attributes) {
        AllowedHTMLTags.addTag(tag, 0, 0, attributes);
    }

    private static void addTags(String[] tags) {
        for (String t : tags) {
            m_hashAllowed.put(t, new TagInfo());
        }
    }

    private static void addCommonAttributes(String[] attributes) {
        for (String s : attributes) {
            m_hashAttributes.put(s, 0);
        }
    }

    private static void addSpecialTags(String[] tags) {
        for (String s : tags) {
            m_hashSpecial.put(s, 0);
        }
    }

    private static void init() {
        if (m_hashAllowed == null) {
            m_hashAllowed = new TreeMap<String, TagInfo>(String.CASE_INSENSITIVE_ORDER);
            m_hashSpecial = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            m_hashAttributes = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            AllowedHTMLTags.addSpecialTags(new String[]{"script", "style", "option", "select", "textarea"});
            AllowedHTMLTags.addTag("a", new String[]{"charset", "href", "hreflang", "name", "rel", "rev", "shape", "tabindex", "type"});
            AllowedHTMLTags.addTag("blockquote", 1, 1, new String[]{"cite"});
            AllowedHTMLTags.addTag("br", 0, 0, new String[]{"clear"});
            AllowedHTMLTags.addTag("caption", 1, 1, new String[]{"align"});
            AllowedHTMLTags.addTag("col", 1, 1, new String[]{"align", "char", "charoff", "span", "valign", "width"});
            AllowedHTMLTags.addTag("colgroup", 1, 1, new String[]{"align", "char", "charoff", "span", "valign", "width"});
            AllowedHTMLTags.addTag("del", 0, 0, new String[]{"cite", "datetime"});
            AllowedHTMLTags.addTag("dir", 2, 2, new String[]{"compact"});
            AllowedHTMLTags.addTag("div", 1, 1, new String[]{"align"});
            AllowedHTMLTags.addTag("dl", 2, 2, new String[]{"compact"});
            AllowedHTMLTags.addTag("font", 0, 0, new String[]{"color", "face", "size"});
            AllowedHTMLTags.addTag("h1", 2, 2, new String[]{"align"});
            AllowedHTMLTags.addTag("h2", 2, 2, new String[]{"align"});
            AllowedHTMLTags.addTag("h3", 2, 2, new String[]{"align"});
            AllowedHTMLTags.addTag("h4", 2, 2, new String[]{"align"});
            AllowedHTMLTags.addTag("h5", 2, 2, new String[]{"align"});
            AllowedHTMLTags.addTag("h6", 2, 2, new String[]{"align"});
            AllowedHTMLTags.addTag("hr", 2, 2, new String[]{"align", "size", "width"});
            AllowedHTMLTags.addTag("img", 0, 0, new String[]{"align", "alt", "border", "height", "hspace", "ismap", "longdesc", "name", "src", "usemap", "vspace", "width", "alt2", "src2"});
            AllowedHTMLTags.addTag("ins", 0, 0, new String[]{"cite", "datetime"});
            AllowedHTMLTags.addTag("li", 1, 1, new String[]{"type", "value"});
            AllowedHTMLTags.addTag("map", 0, 0, new String[]{"name"});
            AllowedHTMLTags.addTag("menu", 2, 2, new String[]{"compact"});
            AllowedHTMLTags.addTag("ol", 2, 2, new String[]{"compact", "start", "type"});
            AllowedHTMLTags.addTag("p", 1, 1, new String[]{"align"});
            AllowedHTMLTags.addTag("pre", 1, 1, new String[]{"width"});
            AllowedHTMLTags.addTag("q", 0, 0, new String[]{"cite"});
            AllowedHTMLTags.addTag("table", 2, 2, new String[]{"align", "border", "cellpadding", "cellspacing", "frame", "rules", "summary", "width", "caption"});
            AllowedHTMLTags.addTag("tbody", 0, 0, new String[]{"align", "char", "charoff", "valign"});
            AllowedHTMLTags.addTag("td", 2, 2, new String[]{"abbr", "align", "axis", "char", "charoff", "colspan", "headers", "height", "nowrap", "rowspan", "scope", "valign", "width"});
            AllowedHTMLTags.addTag("tfoot", 2, 2, new String[]{"align", "char", "charoff", "valign"});
            AllowedHTMLTags.addTag("th", 2, 2, new String[]{"abbr", "align", "axis", "char", "charoff", "colspan", "headers", "height", "nowrap", "rowspan", "scope", "valign", "width"});
            AllowedHTMLTags.addTag("thead", 2, 2, new String[]{"align", "char", "charoff", "valign"});
            AllowedHTMLTags.addTag("tr", 2, 2, new String[]{"align", "char", "charoff", "valign"});
            AllowedHTMLTags.addTag("ul", 2, 2, new String[]{"compact", "type"});
            AllowedHTMLTags.addTag("dd", 1, 2, new String[0]);
            AllowedHTMLTags.addTag("dt", 2, 1, new String[0]);
            AllowedHTMLTags.addTags(new String[]{"abbr", "acronym", "address", "b", "bdo", "big", "center", "cite", "code", "dfn", "em", "i", "kbd", "s", "samp", "small", "span", "strike", "strong", "sub", "sup", "tt", "u", "var"});
            AllowedHTMLTags.addCommonAttributes(new String[]{"dir", "lang", "title", "style", "id", "class", "contenteditable"});
        }
    }

    private static class TagInfo {
        protected int m_eolBefore;
        protected int m_eolAfter;
        protected Map<String, Integer> m_attributes;
    }
}

