/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.xml;

import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtils {
    public static String getText(Node node) {
        Check.notNull(node, "node");
        short type = node.getNodeType();
        if (1 == type) {
            NodeList children = node.getChildNodes();
            StringBuffer buffer = new StringBuffer();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                short childType = child.getNodeType();
                if (3 != childType && 4 != childType) continue;
                buffer.append(child.getNodeValue());
            }
            return buffer.toString();
        }
        if (3 == type || 4 == type) {
            return node.getNodeValue();
        }
        return "";
    }

    public static Element getRootElement(Element descendant) {
        Element element = descendant;
        while (element.getParentNode() != null && element.getParentNode() instanceof Element) {
            element = (Element)element.getParentNode();
        }
        return element;
    }

    public static Element[] getChildElements(Node node) {
        return DOMUtils.getChildElementsInternal(node, false, null, null);
    }

    public static Element[] getChildElements(Node node, String tagName) {
        return DOMUtils.getChildElementsInternal(node, false, null, tagName);
    }

    public static Element[] getChildElementsNS(Node node, String namespaceURI, String localName) {
        return DOMUtils.getChildElementsInternal(node, true, namespaceURI, localName);
    }

    public static Element getFirstChildElement(Node node) {
        return DOMUtils.getFirstChildElementInternal(node, false, null, null);
    }

    public static Element getFirstChildElement(Node node, String tagName) {
        return DOMUtils.getFirstChildElementInternal(node, false, null, tagName);
    }

    public static Element getFirstChildElementNS(Node node, String namespaceURI, String localName) {
        return DOMUtils.getFirstChildElementInternal(node, true, namespaceURI, localName);
    }

    public static Element appendChild(Element parent, String tagName) {
        Check.notNull(parent, "parent");
        Element newChild = parent.getOwnerDocument().createElement(tagName);
        parent.appendChild(newChild);
        return newChild;
    }

    public static Element appendChildNS(Element parent, String namespaceURI, String qualifiedName) {
        Check.notNull(parent, "parent");
        Element newChild = parent.getOwnerDocument().createElementNS(namespaceURI, qualifiedName);
        parent.appendChild(newChild);
        return newChild;
    }

    public static Text appendText(Element parent, String data) {
        Check.notNull(parent, "parent");
        Text newChild = parent.getOwnerDocument().createTextNode(data);
        parent.appendChild(newChild);
        return newChild;
    }

    public static CDATASection appendCDATA(Element parent, String data) {
        Check.notNull(parent, "parent");
        CDATASection newChild = parent.getOwnerDocument().createCDATASection(data);
        parent.appendChild(newChild);
        return newChild;
    }

    public static Element appendChildWithText(Element parent, String tagName, String data) {
        Check.notNull(parent, "parent");
        Element newChild = DOMUtils.appendChild(parent, tagName);
        DOMUtils.appendText(newChild, data);
        return newChild;
    }

    public static Element appendChildWithTextNS(Element parent, String namespaceURI, String qualifiedName, String data) {
        Element newChild = DOMUtils.appendChildNS(parent, namespaceURI, qualifiedName);
        DOMUtils.appendText(newChild, data);
        return newChild;
    }

    public static Element appendChildWithCDATA(Element parent, String tagName, String data) {
        Element newChild = DOMUtils.appendChild(parent, tagName);
        DOMUtils.appendCDATA(newChild, data);
        return newChild;
    }

    public static Element appendChildWithCDATANS(Element parent, String namespaceURI, String qualifiedName, String data) {
        Element newChild = DOMUtils.appendChildNS(parent, namespaceURI, qualifiedName);
        DOMUtils.appendCDATA(newChild, data);
        return newChild;
    }

    private static Element[] getChildElementsInternal(Node node, boolean useNamespaces, String namespaceURI, String localName) {
        NodeList children = node.getChildNodes();
        ArrayList<Node> childElements = new ArrayList<Node>();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (1 != child.getNodeType() || !DOMUtils.matches(child, useNamespaces, namespaceURI, localName)) continue;
            childElements.add(child);
        }
        return childElements.toArray(new Element[childElements.size()]);
    }

    private static Element getFirstChildElementInternal(Node node, boolean useNamespaces, String namespaceURI, String localName) {
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (1 != child.getNodeType() || !DOMUtils.matches(child, useNamespaces, namespaceURI, localName)) continue;
            return (Element)child;
        }
        return null;
    }

    private static boolean matches(Node node, boolean useNamespaces, String namespaceURI, String localName) {
        if (useNamespaces) {
            if (namespaceURI == null && node.getNamespaceURI() != null) {
                return false;
            }
            if (namespaceURI != null && !namespaceURI.equals("*") && !namespaceURI.equals(node.getNamespaceURI())) {
                return false;
            }
        }
        if (localName == null || localName.equals("*")) {
            return true;
        }
        if (useNamespaces) {
            return localName.equals(node.getLocalName());
        }
        return localName.equals(node.getNodeName());
    }
}

