/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;

public final class StandardNames {
    @NotNull
    public static final StandardNames INSTANCE = new StandardNames();
    @JvmField
    @NotNull
    public static final Name ENUM_VALUES;
    @JvmField
    @NotNull
    public static final Name ENUM_VALUE_OF;
    @JvmField
    @NotNull
    public static final Name CHAR_CODE;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName RESULT_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName KOTLIN_REFLECT_FQ_NAME;
    @JvmField
    @NotNull
    public static final List<String> PREFIXES;
    @JvmField
    @NotNull
    public static final Name BUILT_INS_PACKAGE_NAME;
    @JvmField
    @NotNull
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName RANGES_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName TEXT_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final Set<FqName> BUILT_INS_PACKAGE_FQ_NAMES;

    private StandardNames() {
    }

    @JvmStatic
    @NotNull
    public static final String getFunctionName(int parameterCount) {
        return Intrinsics.stringPlus("Function", parameterCount);
    }

    @JvmStatic
    @NotNull
    public static final ClassId getFunctionClassId(int parameterCount) {
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, Name.identifier(StandardNames.getFunctionName(parameterCount)));
    }

    @JvmStatic
    @NotNull
    public static final String getSuspendFunctionName(int parameterCount) {
        return Intrinsics.stringPlus(FunctionClassKind.SuspendFunction.getClassNamePrefix(), parameterCount);
    }

    @JvmStatic
    public static final boolean isPrimitiveArray(@NotNull FqNameUnsafe arrayFqName) {
        Intrinsics.checkNotNullParameter(arrayFqName, "arrayFqName");
        return FqNames.arrayClassFqNameToPrimitiveType.get(arrayFqName) != null;
    }

    @JvmStatic
    @NotNull
    public static final FqName getPrimitiveFqName(@NotNull PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)primitiveType, "primitiveType");
        FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.getTypeName());
        Intrinsics.checkNotNullExpressionValue(fqName2, "BUILT_INS_PACKAGE_FQ_NAM\u2026d(primitiveType.typeName)");
        return fqName2;
    }

    static {
        Object object = Name.identifier("values");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"values\")");
        ENUM_VALUES = object;
        object = Name.identifier("valueOf");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"valueOf\")");
        ENUM_VALUE_OF = object;
        object = Name.identifier("code");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"code\")");
        CHAR_CODE = object;
        COROUTINES_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines");
        COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.jvm.internal");
        COROUTINES_INTRINSICS_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.intrinsics");
        object = COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue(object, "COROUTINES_PACKAGE_FQ_NA\u2026entifier(\"Continuation\"))");
        CONTINUATION_INTERFACE_FQ_NAME = object;
        RESULT_FQ_NAME = new FqName("kotlin.Result");
        KOTLIN_REFLECT_FQ_NAME = new FqName("kotlin.reflect");
        object = new String[]{"KProperty", "KMutableProperty", "KFunction", "KSuspendFunction"};
        PREFIXES = kotlin.collections.CollectionsKt.listOf(object);
        object = Name.identifier("kotlin");
        Intrinsics.checkNotNullExpressionValue(object, "identifier(\"kotlin\")");
        BUILT_INS_PACKAGE_NAME = object;
        object = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
        Intrinsics.checkNotNullExpressionValue(object, "topLevel(BUILT_INS_PACKAGE_NAME)");
        BUILT_INS_PACKAGE_FQ_NAME = object;
        object = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("annotation"));
        Intrinsics.checkNotNullExpressionValue(object, "BUILT_INS_PACKAGE_FQ_NAM\u2026identifier(\"annotation\"))");
        ANNOTATION_PACKAGE_FQ_NAME = object;
        object = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("collections"));
        Intrinsics.checkNotNullExpressionValue(object, "BUILT_INS_PACKAGE_FQ_NAM\u2026dentifier(\"collections\"))");
        COLLECTIONS_PACKAGE_FQ_NAME = object;
        object = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("ranges"));
        Intrinsics.checkNotNullExpressionValue(object, "BUILT_INS_PACKAGE_FQ_NAM\u2026ame.identifier(\"ranges\"))");
        RANGES_PACKAGE_FQ_NAME = object;
        object = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("text"));
        Intrinsics.checkNotNullExpressionValue(object, "BUILT_INS_PACKAGE_FQ_NAM\u2026(Name.identifier(\"text\"))");
        TEXT_PACKAGE_FQ_NAME = object;
        object = new FqName[7];
        object[0] = BUILT_INS_PACKAGE_FQ_NAME;
        object[1] = COLLECTIONS_PACKAGE_FQ_NAME;
        object[2] = RANGES_PACKAGE_FQ_NAME;
        object[3] = ANNOTATION_PACKAGE_FQ_NAME;
        object[4] = KOTLIN_REFLECT_FQ_NAME;
        FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("internal"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "BUILT_INS_PACKAGE_FQ_NAM\u2026e.identifier(\"internal\"))");
        object[5] = fqName2;
        object[6] = COROUTINES_PACKAGE_FQ_NAME;
        BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf(object);
    }

    public static final class FqNames {
        @NotNull
        public static final FqNames INSTANCE;
        @JvmField
        @NotNull
        public static final FqNameUnsafe any;
        @JvmField
        @NotNull
        public static final FqNameUnsafe nothing;
        @JvmField
        @NotNull
        public static final FqNameUnsafe cloneable;
        @JvmField
        @NotNull
        public static final FqName suppress;
        @JvmField
        @NotNull
        public static final FqNameUnsafe unit;
        @JvmField
        @NotNull
        public static final FqNameUnsafe charSequence;
        @JvmField
        @NotNull
        public static final FqNameUnsafe string;
        @JvmField
        @NotNull
        public static final FqNameUnsafe array;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _boolean;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _char;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _byte;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _short;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _int;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _long;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _float;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _double;
        @JvmField
        @NotNull
        public static final FqNameUnsafe number;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _enum;
        @JvmField
        @NotNull
        public static final FqNameUnsafe functionSupertype;
        @JvmField
        @NotNull
        public static final FqName throwable;
        @JvmField
        @NotNull
        public static final FqName comparable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe intRange;
        @JvmField
        @NotNull
        public static final FqNameUnsafe longRange;
        @JvmField
        @NotNull
        public static final FqName deprecated;
        @JvmField
        @NotNull
        public static final FqName deprecatedSinceKotlin;
        @JvmField
        @NotNull
        public static final FqName deprecationLevel;
        @JvmField
        @NotNull
        public static final FqName replaceWith;
        @JvmField
        @NotNull
        public static final FqName extensionFunctionType;
        @JvmField
        @NotNull
        public static final FqName parameterName;
        @JvmField
        @NotNull
        public static final FqName annotation;
        @JvmField
        @NotNull
        public static final FqName target;
        @JvmField
        @NotNull
        public static final FqName annotationTarget;
        @JvmField
        @NotNull
        public static final FqName annotationRetention;
        @JvmField
        @NotNull
        public static final FqName retention;
        @JvmField
        @NotNull
        public static final FqName repeatable;
        @JvmField
        @NotNull
        public static final FqName mustBeDocumented;
        @JvmField
        @NotNull
        public static final FqName unsafeVariance;
        @JvmField
        @NotNull
        public static final FqName publishedApi;
        @JvmField
        @NotNull
        public static final FqName iterator;
        @JvmField
        @NotNull
        public static final FqName iterable;
        @JvmField
        @NotNull
        public static final FqName collection;
        @JvmField
        @NotNull
        public static final FqName list;
        @JvmField
        @NotNull
        public static final FqName listIterator;
        @JvmField
        @NotNull
        public static final FqName set;
        @JvmField
        @NotNull
        public static final FqName map;
        @JvmField
        @NotNull
        public static final FqName mapEntry;
        @JvmField
        @NotNull
        public static final FqName mutableIterator;
        @JvmField
        @NotNull
        public static final FqName mutableIterable;
        @JvmField
        @NotNull
        public static final FqName mutableCollection;
        @JvmField
        @NotNull
        public static final FqName mutableList;
        @JvmField
        @NotNull
        public static final FqName mutableListIterator;
        @JvmField
        @NotNull
        public static final FqName mutableSet;
        @JvmField
        @NotNull
        public static final FqName mutableMap;
        @JvmField
        @NotNull
        public static final FqName mutableMapEntry;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kClass;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kCallable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kPropertyFqName;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutablePropertyFqName;
        @JvmField
        @NotNull
        public static final ClassId kProperty;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kDeclarationContainer;
        @JvmField
        @NotNull
        public static final FqName uByteFqName;
        @JvmField
        @NotNull
        public static final FqName uShortFqName;
        @JvmField
        @NotNull
        public static final FqName uIntFqName;
        @JvmField
        @NotNull
        public static final FqName uLongFqName;
        @JvmField
        @NotNull
        public static final ClassId uByte;
        @JvmField
        @NotNull
        public static final ClassId uShort;
        @JvmField
        @NotNull
        public static final ClassId uInt;
        @JvmField
        @NotNull
        public static final ClassId uLong;
        @JvmField
        @NotNull
        public static final FqName uByteArrayFqName;
        @JvmField
        @NotNull
        public static final FqName uShortArrayFqName;
        @JvmField
        @NotNull
        public static final FqName uIntArrayFqName;
        @JvmField
        @NotNull
        public static final FqName uLongArrayFqName;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveTypeShortNames;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveArrayTypeShortNames;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> fqNameToPrimitiveType;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> arrayClassFqNameToPrimitiveType;

        private FqNames() {
        }

        private final FqNameUnsafe fqNameUnsafe(String simpleName2) {
            FqNameUnsafe fqNameUnsafe = this.fqName(simpleName2).toUnsafe();
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "fqName(simpleName).toUnsafe()");
            return fqNameUnsafe;
        }

        private final FqName fqName(String simpleName2) {
            FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "BUILT_INS_PACKAGE_FQ_NAM\u2026e.identifier(simpleName))");
            return fqName2;
        }

        private final FqName collectionsFqName(String simpleName2) {
            FqName fqName2 = COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "COLLECTIONS_PACKAGE_FQ_N\u2026e.identifier(simpleName))");
            return fqName2;
        }

        private final FqNameUnsafe rangesFqName(String simpleName2) {
            FqNameUnsafe fqNameUnsafe = RANGES_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "RANGES_PACKAGE_FQ_NAME.c\u2026r(simpleName)).toUnsafe()");
            return fqNameUnsafe;
        }

        @JvmStatic
        @NotNull
        public static final FqNameUnsafe reflect(@NotNull String simpleName2) {
            Intrinsics.checkNotNullParameter(simpleName2, "simpleName");
            FqNameUnsafe fqNameUnsafe = KOTLIN_REFLECT_FQ_NAME.child(Name.identifier(simpleName2)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "KOTLIN_REFLECT_FQ_NAME.c\u2026r(simpleName)).toUnsafe()");
            return fqNameUnsafe;
        }

        private final FqName annotationName(String simpleName2) {
            FqName fqName2 = ANNOTATION_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "ANNOTATION_PACKAGE_FQ_NA\u2026e.identifier(simpleName))");
            return fqName2;
        }

        static {
            Object object;
            Name name;
            PrimitiveType it;
            Collection collection;
            INSTANCE = new FqNames();
            any = INSTANCE.fqNameUnsafe("Any");
            nothing = INSTANCE.fqNameUnsafe("Nothing");
            cloneable = INSTANCE.fqNameUnsafe("Cloneable");
            suppress = INSTANCE.fqName("Suppress");
            unit = INSTANCE.fqNameUnsafe("Unit");
            charSequence = INSTANCE.fqNameUnsafe("CharSequence");
            string = INSTANCE.fqNameUnsafe("String");
            array = INSTANCE.fqNameUnsafe("Array");
            _boolean = INSTANCE.fqNameUnsafe("Boolean");
            _char = INSTANCE.fqNameUnsafe("Char");
            _byte = INSTANCE.fqNameUnsafe("Byte");
            _short = INSTANCE.fqNameUnsafe("Short");
            _int = INSTANCE.fqNameUnsafe("Int");
            _long = INSTANCE.fqNameUnsafe("Long");
            _float = INSTANCE.fqNameUnsafe("Float");
            _double = INSTANCE.fqNameUnsafe("Double");
            number = INSTANCE.fqNameUnsafe("Number");
            _enum = INSTANCE.fqNameUnsafe("Enum");
            functionSupertype = INSTANCE.fqNameUnsafe("Function");
            throwable = INSTANCE.fqName("Throwable");
            comparable = INSTANCE.fqName("Comparable");
            intRange = INSTANCE.rangesFqName("IntRange");
            longRange = INSTANCE.rangesFqName("LongRange");
            deprecated = INSTANCE.fqName("Deprecated");
            deprecatedSinceKotlin = INSTANCE.fqName("DeprecatedSinceKotlin");
            deprecationLevel = INSTANCE.fqName("DeprecationLevel");
            replaceWith = INSTANCE.fqName("ReplaceWith");
            extensionFunctionType = INSTANCE.fqName("ExtensionFunctionType");
            parameterName = INSTANCE.fqName("ParameterName");
            annotation = INSTANCE.fqName("Annotation");
            target = INSTANCE.annotationName("Target");
            annotationTarget = INSTANCE.annotationName("AnnotationTarget");
            annotationRetention = INSTANCE.annotationName("AnnotationRetention");
            retention = INSTANCE.annotationName("Retention");
            repeatable = INSTANCE.annotationName("Repeatable");
            mustBeDocumented = INSTANCE.annotationName("MustBeDocumented");
            unsafeVariance = INSTANCE.fqName("UnsafeVariance");
            publishedApi = INSTANCE.fqName("PublishedApi");
            iterator = INSTANCE.collectionsFqName("Iterator");
            iterable = INSTANCE.collectionsFqName("Iterable");
            FqNames.collection = INSTANCE.collectionsFqName("Collection");
            list = INSTANCE.collectionsFqName("List");
            listIterator = INSTANCE.collectionsFqName("ListIterator");
            set = INSTANCE.collectionsFqName("Set");
            map = INSTANCE.collectionsFqName("Map");
            Cloneable cloneable2 = map.child(Name.identifier("Entry"));
            Intrinsics.checkNotNullExpressionValue(cloneable2, "map.child(Name.identifier(\"Entry\"))");
            mapEntry = cloneable2;
            mutableIterator = INSTANCE.collectionsFqName("MutableIterator");
            mutableIterable = INSTANCE.collectionsFqName("MutableIterable");
            mutableCollection = INSTANCE.collectionsFqName("MutableCollection");
            mutableList = INSTANCE.collectionsFqName("MutableList");
            mutableListIterator = INSTANCE.collectionsFqName("MutableListIterator");
            mutableSet = INSTANCE.collectionsFqName("MutableSet");
            mutableMap = INSTANCE.collectionsFqName("MutableMap");
            cloneable2 = mutableMap.child(Name.identifier("MutableEntry"));
            Intrinsics.checkNotNullExpressionValue(cloneable2, "mutableMap.child(Name.identifier(\"MutableEntry\"))");
            mutableMapEntry = cloneable2;
            kClass = FqNames.reflect("KClass");
            kCallable = FqNames.reflect("KCallable");
            kProperty0 = FqNames.reflect("KProperty0");
            kProperty1 = FqNames.reflect("KProperty1");
            kProperty2 = FqNames.reflect("KProperty2");
            kMutableProperty0 = FqNames.reflect("KMutableProperty0");
            kMutableProperty1 = FqNames.reflect("KMutableProperty1");
            kMutableProperty2 = FqNames.reflect("KMutableProperty2");
            kPropertyFqName = FqNames.reflect("KProperty");
            kMutablePropertyFqName = FqNames.reflect("KMutableProperty");
            cloneable2 = ClassId.topLevel(kPropertyFqName.toSafe());
            Intrinsics.checkNotNullExpressionValue(cloneable2, "topLevel(kPropertyFqName.toSafe())");
            kProperty = cloneable2;
            kDeclarationContainer = FqNames.reflect("KDeclarationContainer");
            uByteFqName = INSTANCE.fqName("UByte");
            uShortFqName = INSTANCE.fqName("UShort");
            uIntFqName = INSTANCE.fqName("UInt");
            uLongFqName = INSTANCE.fqName("ULong");
            cloneable2 = ClassId.topLevel(uByteFqName);
            Intrinsics.checkNotNullExpressionValue(cloneable2, "topLevel(uByteFqName)");
            uByte = cloneable2;
            cloneable2 = ClassId.topLevel(uShortFqName);
            Intrinsics.checkNotNullExpressionValue(cloneable2, "topLevel(uShortFqName)");
            uShort = cloneable2;
            cloneable2 = ClassId.topLevel(uIntFqName);
            Intrinsics.checkNotNullExpressionValue(cloneable2, "topLevel(uIntFqName)");
            uInt = cloneable2;
            cloneable2 = ClassId.topLevel(uLongFqName);
            Intrinsics.checkNotNullExpressionValue(cloneable2, "topLevel(uLongFqName)");
            uLong = cloneable2;
            uByteArrayFqName = INSTANCE.fqName("UByteArray");
            uShortArrayFqName = INSTANCE.fqName("UShortArray");
            uIntArrayFqName = INSTANCE.fqName("UIntArray");
            uLongArrayFqName = INSTANCE.fqName("ULongArray");
            HashSet $this$primitiveTypeShortNames_u24lambda_u2d1 = cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            boolean bl = false;
            PrimitiveType[] $this$mapTo$iv = PrimitiveType.values();
            boolean $i$f$mapTo = false;
            for (PrimitiveType item$iv : $this$mapTo$iv) {
                PrimitiveType primitiveType = item$iv;
                collection = $this$primitiveTypeShortNames_u24lambda_u2d1;
                boolean bl2 = false;
                name = it.getTypeName();
                collection.add(name);
            }
            primitiveTypeShortNames = cloneable2;
            HashSet $this$primitiveArrayTypeShortNames_u24lambda_u2d3 = cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            boolean bl3 = false;
            $this$mapTo$iv = PrimitiveType.values();
            $i$f$mapTo = false;
            for (PrimitiveType item$iv : $this$mapTo$iv) {
                it = item$iv;
                collection = $this$primitiveArrayTypeShortNames_u24lambda_u2d3;
                boolean bl4 = false;
                name = it.getArrayTypeName();
                collection.add(name);
            }
            primitiveArrayTypeShortNames = cloneable2;
            Cloneable $this$fqNameToPrimitiveType_u24lambda_u2d4 = cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            boolean bl5 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                Map map = (Map)((Object)$this$fqNameToPrimitiveType_u24lambda_u2d4);
                object = primitiveType.getTypeName().asString();
                Intrinsics.checkNotNullExpressionValue(object, "primitiveType.typeName.asString()");
                object = INSTANCE.fqNameUnsafe((String)object);
                map.put(object, primitiveType);
            }
            fqNameToPrimitiveType = (Map)((Object)cloneable2);
            Cloneable $this$arrayClassFqNameToPrimitiveType_u24lambda_u2d5 = cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            boolean bl6 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                Map map = (Map)((Object)$this$arrayClassFqNameToPrimitiveType_u24lambda_u2d5);
                object = primitiveType.getArrayTypeName().asString();
                Intrinsics.checkNotNullExpressionValue(object, "primitiveType.arrayTypeName.asString()");
                object = INSTANCE.fqNameUnsafe((String)object);
                map.put(object, primitiveType);
            }
            arrayClassFqNameToPrimitiveType = (Map)((Object)cloneable2);
        }
    }
}

