/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.fasterxml.aalto.in;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.kotlin.com.fasterxml.aalto.impl.LocationImpl;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.ByteBasedPNameTable;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.PName;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.ReaderConfig;
import org.jetbrains.kotlin.com.fasterxml.aalto.in.XmlScanner;
import org.jetbrains.kotlin.com.fasterxml.aalto.util.DataUtil;
import org.jetbrains.kotlin.com.fasterxml.aalto.util.XmlCharTypes;
import org.jetbrains.kotlin.com.fasterxml.aalto.util.XmlChars;
import org.jetbrains.kotlin.org.codehaus.stax2.XMLStreamLocation2;

public abstract class ByteBasedScanner
extends XmlScanner {
    protected int _inputPtr;
    protected int _inputEnd;
    protected int _tmpChar = 0;

    protected ByteBasedScanner(ReaderConfig cfg) {
        super(cfg);
        this._pastBytesOrChars = 0L;
        this._rowStartOffset = 0;
    }

    @Override
    protected abstract void _closeSource() throws IOException;

    @Override
    public XMLStreamLocation2 getCurrentLocation() {
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this._pastBytesOrChars + (long)this._inputPtr, this._currRow, this._inputPtr - this._rowStartOffset);
    }

    protected final void markLF(int offset) {
        this._rowStartOffset = offset;
        ++this._currRow;
    }

    protected final void markLF() {
        this._rowStartOffset = this._inputPtr;
        ++this._currRow;
    }

    protected final void setStartLocation() {
        this._startRawOffset = this._pastBytesOrChars + (long)this._inputPtr;
        this._startRow = this._currRow;
        this._startColumn = this._inputPtr - this._rowStartOffset;
    }

    protected abstract int decodeCharForError(byte var1) throws XMLStreamException;

    protected final PName addUTFPName(ByteBasedPNameTable symbols, XmlCharTypes charTypes, int hash, int[] quads, int qlen, int lastQuadBytes) throws XMLStreamException {
        boolean ok;
        int lastQuad;
        int byteLen = (qlen << 2) - 4 + lastQuadBytes;
        if (lastQuadBytes < 4) {
            lastQuad = quads[qlen - 1];
            quads[qlen - 1] = lastQuad << (4 - lastQuadBytes << 3);
        } else {
            lastQuad = 0;
        }
        int ch = quads[0] >>> 24;
        int ix = 1;
        char[] cbuf = this._nameBuffer;
        int cix = 0;
        int[] TYPES = charTypes.NAME_CHARS;
        switch (TYPES[ch]) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                ok = false;
                break;
            }
            case 3: {
                ok = true;
                break;
            }
            default: {
                int needed;
                if ((ch & 0xE0) == 192) {
                    ch &= 0x1F;
                    needed = 1;
                } else if ((ch & 0xF0) == 224) {
                    ch &= 0xF;
                    needed = 2;
                } else if ((ch & 0xF8) == 240) {
                    ch &= 7;
                    needed = 3;
                } else {
                    this.reportInvalidInitial(ch);
                    ch = 1;
                    needed = 1;
                }
                if (ix + needed > byteLen) {
                    this.reportEofInName(cbuf, 0);
                }
                ix += needed;
                int q = quads[0];
                int ch2 = q >> 16 & 0xFF;
                if ((ch2 & 0xC0) != 128) {
                    this.reportInvalidOther(ch2);
                }
                ch = ch << 6 | ch2 & 0x3F;
                if (needed > 1) {
                    ch2 = q >> 8 & 0xFF;
                    if ((ch2 & 0xC0) != 128) {
                        this.reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 2) {
                        ch2 = q & 0xFF;
                        if ((ch2 & 0xC0) != 128) {
                            this.reportInvalidOther(ch2 & 0xFF);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                    }
                }
                ok = XmlChars.is10NameStartChar(ch);
                if (needed <= 2) break;
                cbuf[cix++] = (char)(55296 + ((ch -= 65536) >> 10));
                ch = 0xDC00 | ch & 0x3FF;
            }
        }
        if (!ok) {
            this.reportInvalidNameChar(ch, 0);
        }
        cbuf[cix++] = (char)ch;
        int last_colon = -1;
        while (ix < byteLen) {
            ch = quads[ix >> 2];
            int byteIx = ix & 3;
            ch = ch >> (3 - byteIx << 3) & 0xFF;
            ++ix;
            switch (TYPES[ch]) {
                case 0: 
                case 4: {
                    ok = false;
                    break;
                }
                case 1: {
                    if (last_colon >= 0) {
                        this.reportMultipleColonsInName();
                    }
                    last_colon = cix;
                    ok = true;
                    break;
                }
                case 2: 
                case 3: {
                    ok = true;
                    break;
                }
                default: {
                    int needed;
                    if ((ch & 0xE0) == 192) {
                        ch &= 0x1F;
                        needed = 1;
                    } else if ((ch & 0xF0) == 224) {
                        ch &= 0xF;
                        needed = 2;
                    } else if ((ch & 0xF8) == 240) {
                        ch &= 7;
                        needed = 3;
                    } else {
                        this.reportInvalidInitial(ch);
                        ch = 1;
                        needed = 1;
                    }
                    if (ix + needed > byteLen) {
                        this.reportEofInName(cbuf, cix);
                    }
                    int ch2 = quads[ix >> 2];
                    byteIx = ix & 3;
                    ++ix;
                    if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                        this.reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 1) {
                        ch2 = quads[ix >> 2];
                        byteIx = ix & 3;
                        ++ix;
                        if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                            this.reportInvalidOther(ch2);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                        if (needed > 2) {
                            ch2 = quads[ix >> 2];
                            byteIx = ix & 3;
                            ++ix;
                            if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                                this.reportInvalidOther(ch2 & 0xFF);
                            }
                            ch = ch << 6 | ch2 & 0x3F;
                        }
                    }
                    ok = XmlChars.is10NameChar(ch);
                    if (needed <= 2) break;
                    ch -= 65536;
                    if (cix >= cbuf.length) {
                        this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
                    }
                    cbuf[cix++] = (char)(55296 + (ch >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                }
            }
            if (!ok) {
                this.reportInvalidNameChar(ch, cix);
            }
            if (cix >= cbuf.length) {
                this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
            }
            cbuf[cix++] = (char)ch;
        }
        String baseName = new String(cbuf, 0, cix);
        if (lastQuadBytes < 4) {
            quads[qlen - 1] = lastQuad;
        }
        return symbols.addSymbol(hash, baseName, last_colon, quads, qlen);
    }

    protected void reportInvalidInitial(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    protected void reportInvalidOther(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }
}

