/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ThrowableConstructorIntrinsicFactory;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/FunctionIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "Intrinsic", "js.translator"})
public final class ThrowableConstructorIntrinsicFactory
implements FunctionIntrinsicFactory {
    @NotNull
    public static final ThrowableConstructorIntrinsicFactory INSTANCE = new ThrowableConstructorIntrinsicFactory();

    private ThrowableConstructorIntrinsicFactory() {
    }

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(descriptor2 instanceof ConstructorDescriptor)) {
            return null;
        }
        SimpleType simpleType2 = ((ConstructorDescriptor)descriptor2).getConstructedClass().getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        if (!TypeUtilsKt.isNotNullThrowable(simpleType2)) {
            return null;
        }
        return Intrinsic.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ThrowableConstructorIntrinsicFactory$Intrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "arguments", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    @SourceDebugExtension(value={"SMAP\nThrowableConstructorIntrinsicFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrowableConstructorIntrinsicFactory.kt\norg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ThrowableConstructorIntrinsicFactory$Intrinsic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1747#2,3:57\n*S KotlinDebug\n*F\n+ 1 ThrowableConstructorIntrinsicFactory.kt\norg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/ThrowableConstructorIntrinsicFactory$Intrinsic\n*L\n44#1:57,3\n*E\n"})
    public static final class Intrinsic
    extends FunctionIntrinsic {
        @NotNull
        public static final Intrinsic INSTANCE = new Intrinsic();

        private Intrinsic() {
        }

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            boolean hasCauseParameter;
            List argumentsToPass;
            CallableDescriptor constructor;
            block6: {
                boolean bl;
                Intrinsics.checkNotNullParameter(callInfo, "callInfo");
                Intrinsics.checkNotNullParameter(arguments2, "arguments");
                Intrinsics.checkNotNullParameter(context, "context");
                constructor = callInfo.getResolvedCall().getResultingDescriptor();
                argumentsToPass = CollectionsKt.toMutableList((Collection)arguments2);
                List<ValueParameterDescriptor> list2 = constructor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FqName fqName2;
                        ClassifierDescriptor classifierDescriptor;
                        ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                        boolean bl2 = false;
                        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = it.getType().getConstructor().getDeclarationDescriptor();
                        if (classifierDescriptor2 != null) {
                            Intrinsics.checkNotNull(classifierDescriptor2);
                            fqName2 = DescriptorUtilsKt.getFqNameSafe(classifierDescriptor);
                        } else {
                            fqName2 = null;
                        }
                        if (!Intrinsics.areEqual(fqName2, StandardNames.FqNames.throwable)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = hasCauseParameter = false;
                }
            }
            if (constructor.getValueParameters().size() == 1 && hasCauseParameter) {
                JsExpression jsExpression = Namer.getUndefinedExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "getUndefinedExpression(...)");
                argumentsToPass.add(0, jsExpression);
            }
            return new JsInvocation((JsExpression)JsAstUtils.pureFqn("newThrowable", (JsExpression)Namer.kotlinObject()), argumentsToPass);
        }
    }
}

