/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.DocType;
import org.jetbrains.kotlin.org.jdom.Document;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.IllegalAddException;
import org.jetbrains.kotlin.org.jdom.Parent;
import org.jetbrains.kotlin.org.jdom.internal.ArrayCopy;

final class ContentList
extends AbstractList<Content>
implements RandomAccess {
    private Content[] elementData = null;
    private int size;
    private transient int sizeModCount = Integer.MIN_VALUE;
    private transient int dataModiCount = Integer.MIN_VALUE;
    private final Parent parent;

    ContentList(Parent parent2) {
        this.parent = parent2;
    }

    private final void setModCount(int sizemod, int datamod) {
        this.sizeModCount = sizemod;
        this.dataModiCount = datamod;
    }

    private final int getModCount() {
        return this.sizeModCount;
    }

    private final void incModCount() {
        ++this.dataModiCount;
        ++this.sizeModCount;
    }

    private final void incDataModOnly() {
        ++this.dataModiCount;
    }

    private final int getDataModCount() {
        return this.dataModiCount;
    }

    private final void checkIndex(int index2, boolean excludes) {
        int max;
        int n = max = excludes ? this.size - 1 : this.size;
        if (index2 < 0 || index2 > max) {
            throw new IndexOutOfBoundsException("Index: " + index2 + " Size: " + this.size);
        }
    }

    private final void checkPreConditions(Content child, int index2, boolean replace2) {
        if (child == null) {
            throw new NullPointerException("Cannot add null object");
        }
        this.checkIndex(index2, replace2);
        if (child.getParent() != null) {
            Parent p = child.getParent();
            if (p instanceof Document) {
                throw new IllegalAddException((Element)child, "The Content already has an existing parent document");
            }
            throw new IllegalAddException("The Content already has an existing parent \"" + ((Element)p).getQualifiedName() + "\"");
        }
        if (child == this.parent) {
            throw new IllegalAddException("The Element cannot be added to itself");
        }
        if (this.parent instanceof Element && child instanceof Element && ((Element)child).isAncestor((Element)this.parent)) {
            throw new IllegalAddException("The Element cannot be added as a descendent of itself");
        }
    }

    @Override
    public void add(int index2, Content child) {
        this.checkPreConditions(child, index2, false);
        this.parent.canContainContent(child, index2, false);
        child.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (index2 == this.size) {
            this.elementData[this.size++] = child;
        } else {
            System.arraycopy(this.elementData, index2, this.elementData, index2 + 1, this.size - index2);
            this.elementData[index2] = child;
            ++this.size;
        }
        this.incModCount();
    }

    @Override
    public boolean addAll(Collection<? extends Content> collection) {
        return this.addAll(this.size, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index2, Collection<? extends Content> collection) {
        if (collection == null) {
            throw new NullPointerException("Can not add a null collection to the ContentList");
        }
        this.checkIndex(index2, false);
        if (collection.isEmpty()) {
            return false;
        }
        int addcnt = collection.size();
        if (addcnt == 1) {
            this.add(index2, collection.iterator().next());
            return true;
        }
        this.ensureCapacity(this.size() + addcnt);
        int tmpmodcount = this.getModCount();
        int tmpdmc = this.getDataModCount();
        boolean ok = false;
        int count = 0;
        try {
            for (Content content2 : collection) {
                this.add(index2 + count, content2);
                ++count;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                while (--count >= 0) {
                    this.remove(index2 + count);
                }
                this.setModCount(tmpmodcount, tmpdmc);
            }
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                Content obj = this.elementData[i];
                ContentList.removeParent(obj);
            }
            this.elementData = null;
            this.size = 0;
        }
        this.incModCount();
    }

    void ensureCapacity(int minCapacity) {
        if (this.elementData == null) {
            this.elementData = new Content[Math.max(minCapacity, 4)];
            return;
        }
        if (minCapacity < this.elementData.length) {
            return;
        }
        int newcap = this.size * 3 / 2 + 1;
        this.elementData = ArrayCopy.copyOf(this.elementData, newcap < minCapacity ? minCapacity : newcap);
    }

    @Override
    public Content get(int index2) {
        this.checkIndex(index2, true);
        return this.elementData[index2];
    }

    int indexOfFirstElement() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof Element)) continue;
                return i;
            }
        }
        return -1;
    }

    int indexOfDocType() {
        if (this.elementData != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!(this.elementData[i] instanceof DocType)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Content remove(int index2) {
        this.checkIndex(index2, true);
        Content old = this.elementData[index2];
        ContentList.removeParent(old);
        System.arraycopy(this.elementData, index2 + 1, this.elementData, index2, this.size - index2 - 1);
        this.elementData[--this.size] = null;
        this.incModCount();
        return old;
    }

    private static void removeParent(Content c) {
        c.setParent(null);
    }

    @Override
    public Content set(int index2, Content child) {
        this.checkPreConditions(child, index2, true);
        this.parent.canContainContent(child, index2, true);
        Content old = this.elementData[index2];
        ContentList.removeParent(old);
        child.setParent(this.parent);
        this.elementData[index2] = child;
        this.incDataModOnly();
        return old;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Content> iterator() {
        return new CLIterator();
    }

    @Override
    public ListIterator<Content> listIterator() {
        return new CLListIterator(0);
    }

    @Override
    public ListIterator<Content> listIterator(int start) {
        return new CLListIterator(start);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private void sortInPlace(int[] indexes) {
        int i;
        int[] unsorted = ArrayCopy.copyOf(indexes, indexes.length);
        Arrays.sort(unsorted);
        Content[] usc = new Content[unsorted.length];
        for (i = 0; i < usc.length; ++i) {
            usc[i] = this.elementData[indexes[i]];
        }
        for (i = 0; i < indexes.length; ++i) {
            this.elementData[unsorted[i]] = usc[i];
        }
    }

    private final int binarySearch(int[] indexes, int len, int val, Comparator<? super Content> comp) {
        int left = 0;
        int mid = 0;
        int right = len - 1;
        int cmp = 0;
        Content base = this.elementData[val];
        while (left <= right) {
            mid = left + right >>> 1;
            cmp = comp.compare(base, this.elementData[indexes[mid]]);
            if (cmp == 0) {
                while (cmp == 0 && mid < right && comp.compare(base, this.elementData[indexes[mid + 1]]) == 0) {
                    ++mid;
                }
                return mid + 1;
            }
            if (cmp < 0) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return left;
    }

    @Override
    public final void sort(Comparator<? super Content> comp) {
        if (comp == null) {
            return;
        }
        int sz = this.size;
        int[] indexes = new int[sz];
        int i = 0;
        while (i < sz) {
            int ip = this.binarySearch(indexes, i, i, comp);
            if (ip < i) {
                System.arraycopy(indexes, ip, indexes, ip + 1, i - ip);
            }
            indexes[ip] = i++;
        }
        this.sortInPlace(indexes);
    }

    private final class CLListIterator
    implements ListIterator<Content> {
        private boolean forward = false;
        private boolean canremove = false;
        private boolean canset = false;
        private int expectedmod = -1;
        private int cursor = -1;

        CLListIterator(int start) {
            this.expectedmod = ContentList.this.getModCount();
            this.forward = false;
            ContentList.this.checkIndex(start, false);
            this.cursor = start;
        }

        private void checkConcurrent() {
            if (this.expectedmod != ContentList.this.getModCount()) {
                throw new ConcurrentModificationException("The ContentList supporting this iterator has been modified bysomething other than this Iterator.");
            }
        }

        @Override
        public boolean hasNext() {
            return (this.forward ? this.cursor + 1 : this.cursor) < ContentList.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return (this.forward ? this.cursor : this.cursor - 1) >= 0;
        }

        @Override
        public int nextIndex() {
            return this.forward ? this.cursor + 1 : this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.forward ? this.cursor : this.cursor - 1;
        }

        @Override
        public Content next() {
            int next;
            this.checkConcurrent();
            int n = next = this.forward ? this.cursor + 1 : this.cursor;
            if (next >= ContentList.this.size) {
                throw new NoSuchElementException("next() is beyond the end of the Iterator");
            }
            this.cursor = next;
            this.forward = true;
            this.canremove = true;
            this.canset = true;
            return ContentList.this.elementData[this.cursor];
        }

        @Override
        public Content previous() {
            int prev;
            this.checkConcurrent();
            int n = prev = this.forward ? this.cursor : this.cursor - 1;
            if (prev < 0) {
                throw new NoSuchElementException("previous() is beyond the beginning of the Iterator");
            }
            this.cursor = prev;
            this.forward = false;
            this.canremove = true;
            this.canset = true;
            return ContentList.this.elementData[this.cursor];
        }

        @Override
        public void add(Content obj) {
            this.checkConcurrent();
            int next = this.forward ? this.cursor + 1 : this.cursor;
            ContentList.this.add(next, obj);
            this.expectedmod = ContentList.this.getModCount();
            this.canset = false;
            this.canremove = false;
            this.cursor = next;
            this.forward = true;
        }

        @Override
        public void remove() {
            this.checkConcurrent();
            if (!this.canremove) {
                throw new IllegalStateException("Can not remove an element unless either next() or previous() has been called since the last remove()");
            }
            ContentList.this.remove(this.cursor);
            this.forward = false;
            this.expectedmod = ContentList.this.getModCount();
            this.canremove = false;
            this.canset = false;
        }

        @Override
        public void set(Content obj) {
            this.checkConcurrent();
            if (!this.canset) {
                throw new IllegalStateException("Can not set an element unless either next() or previous() has been called since the last remove() or set()");
            }
            ContentList.this.set(this.cursor, obj);
            this.expectedmod = ContentList.this.getModCount();
        }
    }

    private final class CLIterator
    implements Iterator<Content> {
        private int expect = -1;
        private int cursor = 0;
        private boolean canremove = false;

        private CLIterator() {
            this.expect = ContentList.this.getModCount();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ContentList.this.size;
        }

        @Override
        public Content next() {
            if (ContentList.this.getModCount() != this.expect) {
                throw new ConcurrentModificationException("ContentList was modified outside of this Iterator");
            }
            if (this.cursor >= ContentList.this.size) {
                throw new NoSuchElementException("Iterated beyond the end of the ContentList.");
            }
            this.canremove = true;
            return ContentList.this.elementData[this.cursor++];
        }

        @Override
        public void remove() {
            if (ContentList.this.getModCount() != this.expect) {
                throw new ConcurrentModificationException("ContentList was modified outside of this Iterator");
            }
            if (!this.canremove) {
                throw new IllegalStateException("Can only remove() content after a call to next()");
            }
            this.canremove = false;
            ContentList.this.remove(--this.cursor);
            this.expect = ContentList.this.getModCount();
        }
    }
}

