/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.reporting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0086\u0002J\u0018\u0010\u0007\u001a\u00020\u0005*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u0018\u0010\u0007\u001a\u00020\u0005*\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u001a\u0010\f\u001a\u00020\r*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0012\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0012\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J*\u0010\u0012\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0015\u00a8\u0006\u0019"}, d2={"Lorg/sonarsource/kotlin/api/reporting/KotlinTextRanges;", "", "()V", "contains", "", "Lorg/sonar/api/batch/fs/TextRange;", "other", "merge", "Lorg/sonar/api/batch/fs/InputFile;", "ranges", "", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "textPointerAtOffset", "Lorg/sonar/api/batch/fs/TextPointer;", "psiDocument", "Lorg/jetbrains/kotlin/com/intellij/openapi/editor/Document;", "startOffset", "", "textRange", "endOffset", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "startLine", "endLine", "psiElement", "sonar-kotlin-api"})
@SourceDebugExtension(value={"SMAP\nKotlinTextRanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTextRanges.kt\norg/sonarsource/kotlin/api/reporting/KotlinTextRanges\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1549#2:67\n1620#2,3:68\n1549#2:71\n1620#2,3:72\n*S KotlinDebug\n*F\n+ 1 KotlinTextRanges.kt\norg/sonarsource/kotlin/api/reporting/KotlinTextRanges\n*L\n60#1:67\n60#1:68,3\n61#1:71\n61#1:72,3\n*E\n"})
public final class KotlinTextRanges {
    @NotNull
    public static final KotlinTextRanges INSTANCE = new KotlinTextRanges();

    private KotlinTextRanges() {
    }

    @NotNull
    public final TextRange textRange(@NotNull InputFile $this$textRange, @NotNull Document psiDocument, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        Intrinsics.checkNotNullParameter(psiDocument, "psiDocument");
        Intrinsics.checkNotNullParameter(element, "element");
        return this.textRange($this$textRange, psiDocument, element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
    }

    @NotNull
    public final TextRange textRange(@NotNull InputFile $this$textRange, @NotNull Document psiDocument, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        Intrinsics.checkNotNullParameter(psiDocument, "psiDocument");
        TextPointer startPointer = this.textPointerAtOffset($this$textRange, psiDocument, startOffset);
        TextPointer endPointer = this.textPointerAtOffset($this$textRange, psiDocument, endOffset);
        TextRange textRange2 = $this$textRange.newRange(startPointer.line(), startPointer.lineOffset(), endPointer.line(), endPointer.lineOffset());
        Intrinsics.checkNotNullExpressionValue(textRange2, "newRange(...)");
        return textRange2;
    }

    @NotNull
    public final TextPointer textPointerAtOffset(@NotNull InputFile $this$textPointerAtOffset, @NotNull Document psiDocument, int startOffset) {
        Intrinsics.checkNotNullParameter($this$textPointerAtOffset, "<this>");
        Intrinsics.checkNotNullParameter(psiDocument, "psiDocument");
        int startLineNumber = psiDocument.getLineNumber(startOffset);
        int startLineNumberOffset = psiDocument.getLineStartOffset(startLineNumber);
        int startLineOffset = startOffset - startLineNumberOffset;
        TextPointer textPointer = $this$textPointerAtOffset.newPointer(startLineNumber + 1, startLineOffset);
        Intrinsics.checkNotNullExpressionValue(textPointer, "newPointer(...)");
        return textPointer;
    }

    @NotNull
    public final TextRange textRange(@NotNull KotlinFileContext $this$textRange, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        InputFile inputFile = $this$textRange.getInputFileContext().getInputFile();
        Document document = $this$textRange.getKtFile().getViewProvider().getDocument();
        Intrinsics.checkNotNull(document);
        return this.textRange(inputFile, document, startOffset, endOffset);
    }

    @NotNull
    public final TextRange textRange(@NotNull KotlinFileContext $this$textRange, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        InputFile inputFile = $this$textRange.getInputFileContext().getInputFile();
        Document document = $this$textRange.getKtFile().getViewProvider().getDocument();
        Intrinsics.checkNotNull(document);
        return this.textRange(inputFile, document, psiElement);
    }

    @NotNull
    public final TextRange textRange(@NotNull KotlinFileContext $this$textRange, int startLine, int startOffset, int endLine, int endOffset) {
        Intrinsics.checkNotNullParameter($this$textRange, "<this>");
        TextRange textRange2 = $this$textRange.getInputFileContext().getInputFile().newRange(startLine, startOffset, endLine, endOffset);
        Intrinsics.checkNotNullExpressionValue(textRange2, "newRange(...)");
        return textRange2;
    }

    public final boolean contains(@NotNull TextRange $this$contains, @NotNull TextRange other) {
        Intrinsics.checkNotNullParameter($this$contains, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        return $this$contains.start().compareTo((Object)other.start()) <= 0 && $this$contains.end().compareTo((Object)other.end()) >= 0;
    }

    @NotNull
    public final TextRange merge(@NotNull InputFile $this$merge, @NotNull Iterable<? extends TextRange> ranges) {
        Collection<TextPointer> collection;
        TextRange it;
        boolean bl;
        Collection collection2;
        Iterable<? extends TextRange> $this$mapTo$iv$iv;
        Iterable<? extends TextRange> $this$map$iv;
        Intrinsics.checkNotNullParameter($this$merge, "<this>");
        Intrinsics.checkNotNullParameter(ranges, "ranges");
        Iterable<? extends TextRange> iterable = ranges;
        InputFile inputFile = $this$merge;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            TextRange textRange2 = (TextRange)t;
            collection2 = destination$iv$iv;
            bl = false;
            collection2.add(it.start());
        }
        TextPointer textPointer = (TextPointer)CollectionsKt.minOrNull((List)destination$iv$iv);
        if (textPointer == null) {
            throw new IllegalArgumentException("Can't merge 0 ranges");
        }
        $this$map$iv = ranges;
        collection2 = textPointer;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object object : $this$mapTo$iv$iv) {
            it = (TextRange)object;
            collection = destination$iv$iv;
            bl = false;
            collection.add(it.end());
        }
        collection = (List)destination$iv$iv;
        TextPointer textPointer2 = (TextPointer)CollectionsKt.maxOrNull((Iterable)collection);
        if (textPointer2 == null) {
            throw new IllegalArgumentException("Can't merge 0 ranges");
        }
        TextRange textRange3 = inputFile.newRange((TextPointer)collection2, textPointer2);
        Intrinsics.checkNotNullExpressionValue(textRange3, "newRange(...)");
        return textRange3;
    }

    @NotNull
    public final TextRange merge(@NotNull KotlinFileContext $this$merge, @NotNull Iterable<? extends TextRange> ranges) {
        Intrinsics.checkNotNullParameter($this$merge, "<this>");
        Intrinsics.checkNotNullParameter(ranges, "ranges");
        return this.merge($this$merge.getInputFileContext().getInputFile(), ranges);
    }
}

