/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.AbstractBranchDuplication;
import org.sonarsource.kotlin.checks.DuplicateBranchCheckKt;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;

@Rule(key="S1871")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0014J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/checks/DuplicateBranchCheck;", "Lorg/sonarsource/kotlin/checks/AbstractBranchDuplication;", "()V", "checkDuplicatedBranches", "", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "tree", "Lorg/jetbrains/kotlin/psi/KtElement;", "branches", "", "onAllIdenticalBranches", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nDuplicateBranchCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateBranchCheck.kt\norg/sonarsource/kotlin/checks/DuplicateBranchCheck\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,79:1\n1313#2,2:80\n*S KotlinDebug\n*F\n+ 1 DuplicateBranchCheck.kt\norg/sonarsource/kotlin/checks/DuplicateBranchCheck\n*L\n42#1:80,2\n*E\n"})
public final class DuplicateBranchCheck
extends AbstractBranchDuplication {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void checkDuplicatedBranches(@NotNull KotlinFileContext ctx, @NotNull KtElement tree, @NotNull List<? extends KtElement> branches) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(branches, "branches");
        for (List<KtElement> group : SyntacticEquivalence.INSTANCE.findDuplicatedGroups(branches)) {
            void $this$forEach$iv;
            KtElement original = group.get(0);
            Sequence sequence2 = SequencesKt.filter(SequencesKt.filter(SequencesKt.drop(CollectionsKt.asSequence((Iterable)group), 1), (Function1)new Function1<KtElement, Boolean>(ctx){
                final /* synthetic */ KotlinFileContext $ctx;
                {
                    this.$ctx = $ctx;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtElement it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return DuplicateBranchCheckKt.access$spansMultipleLines(it, this.$ctx);
                }
            }), (Function1)new Function1<KtElement, Boolean>(original, ctx){
                final /* synthetic */ KtElement $original;
                final /* synthetic */ KotlinFileContext $ctx;
                {
                    this.$original = $original;
                    this.$ctx = $ctx;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull KtElement it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (it instanceof KtQualifiedExpression) {
                        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)it;
                        KtElement ktElement = this.$original;
                        Intrinsics.checkNotNull(ktElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
                        if (!DuplicateBranchCheckKt.access$hasSameSignature(ktQualifiedExpression, (KtQualifiedExpression)ktElement, this.$ctx.getBindingContext())) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtElement duplicated = (KtElement)element$iv;
                boolean bl = false;
                TextRange originalRange = KotlinTextRanges.INSTANCE.textRange(ctx, original);
                AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)duplicated, "This branch's code block is the same as the block for the branch on line " + originalRange.start().line() + ".", CollectionsKt.listOf(new SecondaryLocation(originalRange, "Original")), null, 8, null);
            }
        }
    }

    @Override
    protected void onAllIdenticalBranches(@NotNull KotlinFileContext ctx, @NotNull KtElement tree) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(tree, "tree");
    }
}

