/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.teamscale.jsbuild.JsBuildException;
import com.teamscale.jsbuild.export.TsClassGeneratorBase;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.atteo.classindex.ClassIndex;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class TypescriptTypedefExporter {
    public static void main(String[] args) {
        TypescriptTypedefExporter.generateTsDataClasses(new File(args[0]));
    }

    public static void generateTsDataClasses(File typedefsFolder) throws JsBuildException {
        typedefsFolder.mkdirs();
        List filesToDelete = FileSystemUtils.listFilesRecursively((File)typedefsFolder);
        ArrayList<File> updatedFiles = new ArrayList<File>();
        for (Class subclass : ClassIndex.getSubclasses(TsClassGeneratorBase.class)) {
            try {
                Constructor constructor = subclass.getConstructor(File.class);
                TsClassGeneratorBase generator = (TsClassGeneratorBase)constructor.newInstance(typedefsFolder);
                generator.generateFiles();
                updatedFiles.addAll(generator.getWrittenFiles());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JsBuildException(subclass.getName() + " no public constructor found that takes a File.", e);
            }
            catch (IOException e) {
                throw new JsBuildException(e.getMessage(), e);
            }
        }
        filesToDelete.removeAll(updatedFiles);
        for (File file : filesToDelete) {
            file.delete();
        }
    }
}

