/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdBase;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;

@IndexValueClass(containedInBackup=true)
public class MetricThresholdGroup
extends NamedConfigurableObjectBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="metricThresholdList")
    private final List<MetricThreshold> metricThresholdList = new ArrayList<MetricThreshold>();

    @JsonCreator
    public MetricThresholdGroup(@JsonProperty(value="name") String name) {
        super(name);
    }

    public MetricThresholdGroup(String name, List<MetricThreshold> metricThresholds) {
        super(name);
        this.metricThresholdList.addAll(metricThresholds);
    }

    public UnmodifiableList<MetricThreshold> getMetricThresholdList() {
        return CollectionUtils.asUnmodifiable(this.metricThresholdList);
    }

    @TestOnly
    public MetricThreshold addMetricThreshold(String metricName) {
        MetricThreshold threshold = new MetricThreshold(metricName);
        this.metricThresholdList.add(threshold);
        return threshold;
    }

    public void addMetricThreshold(MetricThreshold metricThreshold) throws MetricThresholdConfigurationException {
        ArrayList<MetricThreshold> temp = new ArrayList<MetricThreshold>(this.metricThresholdList);
        temp.add(metricThreshold);
        this.validateDisplayNamesUnique(temp);
        this.metricThresholdList.add(metricThreshold);
    }

    public Optional<MetricThreshold> findThresholdByDisplayName(String displayName) {
        CCSMAssert.isNotNull((Object)displayName);
        return this.metricThresholdList.stream().filter(threshold -> threshold.getDisplayName().equals(displayName)).findFirst();
    }

    public void validate() throws MetricThresholdConfigurationException {
        for (MetricThreshold metricThreshold : this.metricThresholdList) {
            metricThreshold.validate();
        }
        this.validateDisplayNamesUnique();
    }

    protected void validateDisplayNamesUnique() throws MetricThresholdConfigurationException {
        this.validateDisplayNamesUnique(this.metricThresholdList);
    }

    private void validateDisplayNamesUnique(List<MetricThreshold> metricThresholds) throws MetricThresholdConfigurationException {
        HashSet<String> displayNames = new HashSet<String>();
        for (MetricThreshold metricThreshold : metricThresholds) {
            boolean added = displayNames.add(metricThreshold.getDisplayName());
            if (added) continue;
            throw new MetricThresholdConfigurationException("The group '" + this.getName() + "' contains a threshold with a non-unique display name: " + metricThreshold.getDisplayName());
        }
    }

    public void adjustValues() {
        this.metricThresholdList.forEach(MetricThresholdBase::adjustValues);
    }
}

