/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.EPasswordType;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum EIssueTracker implements IConnectorEnum<EIssueTracker>
{
    JIRA("Jira", "images/connectors/jira.svg", "https://www.atlassian.com/en/software/jira", "Loads issues from the Jira tracker.", true, EPasswordType.PASSWORD_OR_ACCESS_TOKEN),
    TFS("Azure DevOps Boards", "images/connectors/azure_devops.png", "https://docs.microsoft.com/en-us/azure/devops/boards/index?view=azure-devops", "Loads work items from Azure DevOps Boards (formerly known as TFS).", true, EPasswordType.ACCESS_TOKEN),
    GITHUB("Github", "images/connectors/github.svg", "https://github.com", "Loads issues from a Github repository.", true, EPasswordType.PASSWORD_OR_ACCESS_TOKEN),
    GITHUB_APP_BASED("Github (app based)", "images/connectors/github.svg", "https://github.com", "Loads issues from a Github repository using an existing app installation.", false, EPasswordType.PASSWORD_OR_ACCESS_TOKEN),
    RTC("IBM RTC/Jazz", "images/connectors/jazz.png", "http://www.jazz.net/", "Loads issues from an IBM RTC/Jazz server."),
    COMMIT_MESSAGE("Commit Message Issues", "images/teamscale-logo-without-text.svg", "http://www.teamscale.com", "Extracts issues from the commit messages.", false),
    GITLAB("GitLab Issues", "images/connectors/gitlab.svg", "https://about.gitlab.com/", "Loads issues from a GitLab repository.", true, EPasswordType.ACCESS_TOKEN),
    RADAR("Radar", "images/connectors/radar.png", "https://radar.apple.com/", "Loads issues from Radar.");

    private static final Map<String, EIssueTracker> ISSUE_TRACKER_BY_READABLE_NAME;
    private static final String PASSWORD_TYPE_PROPERTY_NAME = "passwordType";
    private static final String ACCOUNT_BASED_PROPERTY_NAME = "accountBased";
    private static final String READABLE_NAME_PROPERTY_NAME = "readableName";
    private static final String LOGO_URL_PROPERTY_NAME = "logoUrl";
    private static final String WEBSITE_URL_PROPERTY_NAME = "websiteUrl";
    private static final String DESCRIPTION_PROPERTY_NAME = "description";
    @JsonProperty(value="readableName")
    private final String readableName;
    @JsonProperty(value="logoUrl")
    private final String logoUrl;
    @JsonProperty(value="websiteUrl")
    private final String websiteUrl;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="accountBased")
    private final boolean accountBased;
    @JsonProperty(value="passwordType")
    private final EPasswordType passwordType;

    private EIssueTracker(@JsonProperty(value="websiteUrl") String readableName, @JsonProperty(value="description") String logoUrl, @JsonProperty(value="accountBased") String websiteUrl, @JsonProperty(value="passwordType") String description, boolean accountBased, EPasswordType passwordType) {
        this.readableName = readableName;
        this.logoUrl = logoUrl;
        this.websiteUrl = websiteUrl;
        this.description = description;
        this.accountBased = accountBased;
        this.passwordType = passwordType;
    }

    private EIssueTracker(String readableName, String logoUrl, String websiteUrl, String description, boolean accountBased) {
        this(readableName, logoUrl, websiteUrl, description, accountBased, EPasswordType.PASSWORD);
    }

    private EIssueTracker(String readableName, String logoUrl, String websiteUrl, String description) {
        this(readableName, logoUrl, websiteUrl, description, true, EPasswordType.PASSWORD);
    }

    @Override
    public String getReadableName() {
        return this.readableName;
    }

    @Override
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @Override
    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public @Nullable String getLongDescription() {
        return null;
    }

    @Override
    public EPasswordType getPasswordType() {
        return this.passwordType;
    }

    @Override
    public Boolean isBeta() {
        return false;
    }

    public static Optional<EIssueTracker> findByReadableName(String readableName) {
        return Optional.ofNullable(ISSUE_TRACKER_BY_READABLE_NAME.get(readableName));
    }

    public static UnmodifiableSet<String> getReadableNames() {
        return CollectionUtils.asUnmodifiable(ISSUE_TRACKER_BY_READABLE_NAME.keySet());
    }

    static {
        ISSUE_TRACKER_BY_READABLE_NAME = Collections.unmodifiableMap(Arrays.stream(EIssueTracker.values()).collect(Collectors.toMap(EIssueTracker::getReadableName, Function.identity())));
    }
}

