/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum EAuthenticationTool {
    TEAMSCALE("Teamscale", false),
    CROWD("Crowd"),
    LDAP("LDAP"),
    GITHUB("GitHub"),
    TFS("Azure DevOps"),
    SAML("SAML", false);

    private final String displayName;
    private final boolean isExternal;
    private static final UnmodifiableMap<String, EAuthenticationTool> BY_DISPLAY_NAME;

    private EAuthenticationTool(String displayName) {
        this(displayName, true);
    }

    private EAuthenticationTool(String displayName, boolean isExternal) {
        this.displayName = displayName;
        this.isExternal = isExternal;
    }

    public static Optional<EAuthenticationTool> byDisplayName(String displayName) {
        return Optional.ofNullable((EAuthenticationTool)((Object)BY_DISPLAY_NAME.get((Object)displayName.toLowerCase())));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        BY_DISPLAY_NAME = CollectionUtils.asUnmodifiable(Arrays.stream(EAuthenticationTool.values()).collect(Collectors.toMap(tool -> tool.displayName.toLowerCase(), Function.identity())));
    }
}

