/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.ISsoAuthenticatorOption;
import com.teamscale.core.authenticate.OAuthStateUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationValidator;
import com.teamscale.core.authenticate.github.GitHubUtils;
import com.teamscale.core.authenticate.github.client.GitHubAppClient;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndexSynchronizer;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.authenticate.index.OAuthStateIndex;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="auth.github.application", name="GitHub Application", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.GITHUB, orderingHint=500)
@IndexValueClass(containedInBackup=true)
public class GitHubApplicationDescription
implements ISsoAuthenticatorOption {
    private static final Logger LOGGER = LogManager.getLogger(GitHubApplicationDescription.class);
    private static final long serialVersionUID = 1L;
    public static final String ALLOWED_ORGANIZATIONS_FOR_SSO_OPTION_NAME = "Allowed Organizations for SSO";
    public static final String DEFAULT_GROUPS_FOR_IMPORTED_USERS_OPTION_NAME = "Default groups for imported users";
    private transient GitHubApplicationValidator gitHubApplicationValidator;
    @JsonIgnore
    private boolean shouldSynchronizeInstallationIndex = false;
    @JsonIgnore
    private @Nullable String previousAppId = null;
    @JsonProperty(value="serverUrl")
    @OptionFieldDescription(name="GitHub URL")
    public String serverUrl = "https://github.com/";
    @JsonProperty(value="appId")
    @OptionFieldDescription(name="ID of the GitHub App")
    public String appId;
    @JsonProperty(value="urlName")
    @OptionFieldDescription(name="App Name (as used in the URL)")
    public String urlName;
    @JsonProperty(value="privateKey")
    @MultilineOption
    @OptionFieldDescription(name="Application private key (PEM)")
    public String privateKey;
    @JsonProperty(value="webhookSecret")
    @OptionFieldDescription(name="Secret used for securing webhook calls (optional)")
    @PasswordOption
    public String webhookSecret;
    @JsonProperty(value="clientId")
    @OptionFieldDescription(name="OAuth client id")
    public String clientId;
    @JsonProperty(value="clientSecret")
    @OptionFieldDescription(name="OAuth client secret")
    @PasswordOption
    public String clientSecret;
    @JsonProperty(value="skipCollaboratorCheck")
    @OptionFieldDescription(name="Skip check if the current user is a collaborator during project creation")
    public boolean skipCollaboratorCheck = EFeatureToggle.ENABLE_DEV_MODE.isEnabled();
    @JsonProperty(value="useForSso")
    @OptionFieldDescription(name="Use GitHub for Single sign-on (SSO)")
    public boolean useForSso = true;
    @JsonProperty(value="loginButtonDisplayName")
    @OptionFieldDescription(name="Display name for the login button")
    public String loginButtonDisplayName;
    @JsonProperty(value="createUserOnFirstLogin")
    @OptionFieldDescription(name="Create a new user on first login")
    public boolean createUserOnFirstLogin = true;
    @JsonProperty(value="allowedOrganizations")
    @OptionFieldDescription(name="Allowed Organizations for SSO", description="Comma-separated list of organizations whose members are allowed to login with SSO. If this option is not set, logins will not be possible. Note: When saving the application, no validation is performed to check whether the organizations exist, so make sure you have entered them correctly.")
    public String allowedOrganizations;
    @JsonProperty(value="groups")
    @OptionFieldDescription(name="Default groups for imported users")
    public String groups;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        this.initValidator();
        return this.gitHubApplicationValidator.validate(storageInfo).orElse(null);
    }

    public Optional<String> validateApplication() {
        this.initValidator();
        return this.gitHubApplicationValidator.validateApplication();
    }

    private void initValidator() {
        if (this.gitHubApplicationValidator == null) {
            this.gitHubApplicationValidator = new GitHubApplicationValidator(this);
        }
    }

    @Override
    public Optional<String> buildRedirectionLink(URI baseUri, @Nullable String redirectionTarget, String sessionToken, OAuthStateIndex oAuthStateIndex) throws StorageException {
        if (!this.useForSso || this.validateApplication().isPresent()) {
            return Optional.empty();
        }
        String csrfToken = OAuthStateUtils.generateCSRFToken();
        OAuthStateUtils.storeCsrfToken(csrfToken, sessionToken, oAuthStateIndex);
        State secureState = new State(this.appId, this.serverUrl, redirectionTarget, csrfToken);
        String oauthUrl = StringUtils.ensureEndsWith((String)this.serverUrl, (String)"/") + "login/oauth/authorize?client_id=" + this.clientId + "&state=" + secureState.toQueryString();
        return Optional.of(oauthUrl);
    }

    long getAppId() throws NumberFormatException {
        return Long.parseLong(this.appId);
    }

    public String getApiServer() {
        return GitHubUtils.getApiBaseUrl(this.serverUrl);
    }

    public boolean isPublicGitHub() {
        return GitHubUtils.isPublicGitHub(this.serverUrl);
    }

    public List<String> getGroups() {
        if (StringUtils.isEmpty((String)this.groups)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.groups.split(",")).map(String::trim).filter(group -> !group.isEmpty()).toList();
    }

    public List<String> getAllowedOrganizations() {
        if (StringUtils.isEmpty((String)this.allowedOrganizations)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.allowedOrganizations.split(",")).map(String::trim).filter(organization -> !organization.isEmpty()).toList();
    }

    @Override
    public String getDisplayName() {
        return this.loginButtonDisplayName;
    }

    @Override
    public ESsoAuthenticatorType getAuthenticatorType() {
        return ESsoAuthenticatorType.GITHUB;
    }

    @Override
    public void integrateExistingOption(IOption existingOption) {
        if (existingOption == null) {
            this.shouldSynchronizeInstallationIndex = true;
            return;
        }
        if (!(existingOption instanceof GitHubApplicationDescription)) {
            return;
        }
        GitHubApplicationDescription existingApplicationDescription = (GitHubApplicationDescription)existingOption;
        if (!this.serverUrl.equals(existingApplicationDescription.serverUrl) || !this.appId.equals(existingApplicationDescription.appId)) {
            this.previousAppId = existingApplicationDescription.appId;
            this.shouldSynchronizeInstallationIndex = true;
        }
    }

    @Override
    public void executedActionsAfterModification(IndexLayer indexLayer) throws StorageException {
        if (!this.shouldSynchronizeInstallationIndex) {
            return;
        }
        LOGGER.debug("Updating GitHub app with ID {} in installation index", (Object)this.previousAppId);
        GitHubInstallationIndex installationIndex = indexLayer.openGlobalIndex(GitHubInstallationIndex.class);
        if (this.previousAppId != null) {
            installationIndex.removeApp(this.previousAppId);
        }
        try {
            GitHubInstallationIndexSynchronizer.performSynchronisationWithAppSpecificClient(installationIndex, new GitHubAppClient(this, indexLayer.openGlobalIndex(AccessTokenIndex.class), LOGGER), LOGGER);
            this.shouldSynchronizeInstallationIndex = false;
        }
        catch (ServiceCallException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Synchronization of GitHub installation index failed for GitHub App {} (id: {}, URL: {})", (Object)this.urlName, (Object)this.appId, (Object)this.serverUrl);
        }
    }

    @Override
    public void executedActionsBeforeDeletion(IndexLayer indexLayer, String optionId) throws StorageException {
        indexLayer.openGlobalIndex(GitHubInstallationIndex.class).removeApp(this.appId);
    }

    @TestOnly
    void setGitHubApplicationValidator(GitHubApplicationValidator gitHubApplicationValidator) {
        this.gitHubApplicationValidator = gitHubApplicationValidator;
    }

    public record State(String appId, String serverUrl, @Nullable String redirectionTarget, String csrfToken) {
        public static State fromQueryString(String queryString) throws ConQATException {
            byte[] decoded;
            try {
                decoded = Base64.getDecoder().decode(queryString);
            }
            catch (IllegalArgumentException e) {
                throw new ConQATException("Query string is not base64 encoded: %s".formatted(queryString), (Throwable)e);
            }
            String json = new String(decoded, StandardCharsets.UTF_8);
            return (State)JsonUtils.deserializeFromJson((String)json, State.class);
        }

        public String toQueryString() {
            String json = JsonUtils.serializeToJSON((Object)this);
            String encoded = Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
            return UrlUtils.encodeQueryParameter((String)encoded);
        }
    }
}

