/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.tfs;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.ImportGroupsStrategyBase;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationServerDescription;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationUtils;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.function.FunctionWithException;

class TfsImportGroupsStrategy
extends ImportGroupsStrategyBase<TfsAuthorizationServerDescription> {
    private final ExternalCredentials externalCredentials;

    public TfsImportGroupsStrategy(NamedServer<TfsAuthorizationServerDescription> server, ExternalCredentials externalCredentials, UserGroupIndex groupIndex, UserIndex userIndex, IMessageBroker messageBroker, FunctionWithException<EAuthenticationTool, IAuthenticationToolProvider, StorageException> toolProviderFactory) {
        super(server, groupIndex, userIndex, messageBroker, toolProviderFactory);
        this.externalCredentials = externalCredentials;
    }

    @Override
    protected UserGroup findGroup(String groupName) throws AuthenticationToolException {
        return TfsAuthorizationUtils.findGroupByName(this.externalCredentials, this.getServer().name(), groupName).orElseThrow(() -> new AuthenticationEntityNotFoundException("TFS Group '" + groupName + "' does not exist."));
    }

    @Override
    protected ListMap<NamedServer<TfsAuthorizationServerDescription>, String> getUsersInGroup(UserGroup group) throws AuthenticationToolException {
        return ListMap.of(this.getServer(), TfsAuthorizationUtils.getUsersForGroup(this.externalCredentials, group, ((TfsAuthorizationServerDescription)this.getServer().serverDescription()).userLoginName));
    }
}

