/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.debug;

import com.teamscale.core.debug.DebugDumperBase;
import com.teamscale.core.debug.EDebugDumpEvent;
import com.teamscale.core.index.IndexLayer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.atteo.classindex.ClassIndex;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;
import org.jspecify.annotations.Nullable;

public class DebugDumperRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PREFIX = "com.teamscale.debug-dump.";
    public static final String ENABLED_PROPERTY_NAME = "enabled";
    public static final String ANONYMIZE_PROPERTY_NAME = "anonymize";
    public static final String PATH_PROPERTY_NAME = "path";
    public static final String PROJECTS_PROPERTY_NAME = "projects";
    public static final String EVENT_PROPERTY_NAME = "event";
    private static boolean enabled;
    private static boolean anonymizationEnabled;
    private static String path;
    private static Pattern projectsPattern;
    private static Pattern eventsPattern;
    private static DebugDumperRegistry instance;
    private final List<DebugDumperBase> debugDumpers = new ArrayList<DebugDumperBase>();
    private static final Object LOCK;

    private DebugDumperRegistry() {
        Iterable debugDumperClasses = ClassIndex.getSubclasses(DebugDumperBase.class);
        for (Class debugDumperClass : debugDumperClasses) {
            try {
                this.debugDumpers.add((DebugDumperBase)debugDumperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                LOGGER.error("Error instantiating debug dumper: " + String.valueOf(debugDumperClass));
            }
        }
    }

    public static void initFromSystemProperties() {
        DebugDumperRegistry.setEnabled(Boolean.parseBoolean(System.getProperty("com.teamscale.debug-dump.enabled")));
        DebugDumperRegistry.setAnonymizationEnabled(Boolean.parseBoolean(System.getProperty("com.teamscale.debug-dump.anonymize")));
        DebugDumperRegistry.setPath(System.getProperty("com.teamscale.debug-dump.path"));
        DebugDumperRegistry.setProjectsPattern(System.getProperty("com.teamscale.debug-dump.projects", ".*"));
        DebugDumperRegistry.setEventsPattern(System.getProperty("com.teamscale.debug-dump.event", ".*"));
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static String getPath() {
        return path;
    }

    public static Pattern getProjectsPattern() {
        return projectsPattern;
    }

    public static Pattern getEventsPattern() {
        return eventsPattern;
    }

    public static synchronized DebugDumperRegistry getInstance() {
        if (instance == null) {
            instance = new DebugDumperRegistry();
        }
        return instance;
    }

    public static void setEnabled(boolean enabled) {
        DebugDumperRegistry.enabled = enabled;
    }

    public static void setAnonymizationEnabled(boolean anonymizationEnabled) {
        DebugDumperRegistry.anonymizationEnabled = anonymizationEnabled;
    }

    public static void setPath(String path) {
        DebugDumperRegistry.path = path;
    }

    public static void setProjectsPattern(String projectsPattern) {
        DebugDumperRegistry.projectsPattern = Pattern.compile(projectsPattern);
    }

    public static void setEventsPattern(String eventsPattern) {
        DebugDumperRegistry.eventsPattern = Pattern.compile(eventsPattern);
    }

    public void signalEvent(EDebugDumpEvent event, ProjectInfo projectInfo, IndexLayer indexLayer, @Nullable UUID rollbackId, DebugDumperBase ... additionalDumpers) {
        if (!DebugDumperRegistry.isEnabled(event, projectInfo)) {
            return;
        }
        InternalProjectId projectId = projectInfo.getInternalId();
        try {
            File directory = DebugDumperRegistry.getDumpDirectoryForProject(projectInfo);
            DebugDumperRegistry.dump(this.debugDumpers, projectId, event, indexLayer, directory, rollbackId);
            DebugDumperRegistry.dump(Arrays.asList(additionalDumpers), projectId, event, indexLayer, directory, rollbackId);
        }
        catch (IOException e) {
            LOGGER.error("Failed to debug dump information: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getDumpDirectoryForProject(ProjectInfo projectInfo) throws IOException {
        Path directory = Path.of(path, projectInfo.getPrimaryPublicId().toString());
        Object object = LOCK;
        synchronized (object) {
            FileSystemUtils.ensureDirectoryExists((Path)directory);
        }
        return directory.toFile();
    }

    public static void writeDump(EDebugDumpEvent event, ProjectInfo projectInfo, ConsumerWithTwoExceptions<File, IOException, JsonSerializationException> dump) throws IOException, JsonSerializationException {
        if (DebugDumperRegistry.isEnabled(event, projectInfo)) {
            dump.accept((Object)DebugDumperRegistry.getDumpDirectoryForProject(projectInfo));
        }
    }

    private static void dump(List<DebugDumperBase> dumpers, InternalProjectId projectId, EDebugDumpEvent event, IndexLayer indexLayer, File directory, @Nullable UUID rollbackId) throws IOException {
        long now = System.currentTimeMillis();
        for (DebugDumperBase dumper : dumpers) {
            if (dumper.isProjectSpecific() && projectId == null) continue;
            StringBuilder dumpFileName = new StringBuilder();
            if (rollbackId == null) {
                dumpFileName.append("##no-rollback-id##");
            } else {
                dumpFileName.append(rollbackId);
            }
            dumpFileName.append("-").append(now).append("-").append(event.name().toLowerCase()).append("-").append(dumper.getName()).append(".txt");
            try (PrintWriter writer = new PrintWriter(new File(directory, dumpFileName.toString()), StandardCharsets.UTF_8);){
                try {
                    dumper.dump(indexLayer, projectId, writer);
                }
                catch (StorageException e) {
                    writer.println("Failed to complete dump due to exception: " + e.getMessage());
                    e.printStackTrace(writer);
                }
            }
        }
    }

    public static boolean isEnabled(EDebugDumpEvent event, ProjectInfo projectInfo) {
        if (!enabled || path == null) {
            return false;
        }
        if (projectInfo != null && !projectsPattern.matcher(projectInfo.getInternalId().toString()).matches() && projectInfo.getPublicIds().stream().noneMatch(projectId -> projectsPattern.matcher(projectId.toString()).matches())) {
            return false;
        }
        return eventsPattern.matcher(event.name()).matches();
    }

    public static boolean isAnonymizationEnabled() {
        return anonymizationEnabled;
    }

    static {
        LOCK = new Object();
        DebugDumperRegistry.initFromSystemProperties();
    }
}

