/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class IndexCache<KEY_TYPE, INDEX_TYPE, CACHED_TYPE> {
    protected final Cache<KEY_TYPE, @NonNull Optional<@Nullable CACHED_TYPE>> cache;
    protected final FunctionWithException<@NonNull INDEX_TYPE, @NonNull CACHED_TYPE, StorageException> mapper;
    private final FunctionWithException<KEY_TYPE, INDEX_TYPE, StorageException> getSingleItem;
    private final FunctionWithException<List<KEY_TYPE>, List<INDEX_TYPE>, StorageException> getMultipleItems;

    public IndexCache(List<KEY_TYPE> keysToPreload, FunctionWithException<INDEX_TYPE, CACHED_TYPE, StorageException> mapper, FunctionWithException<KEY_TYPE, INDEX_TYPE, StorageException> getSingleItem, FunctionWithException<List<KEY_TYPE>, List<INDEX_TYPE>, StorageException> getMultipleItems) throws StorageException {
        this(cache -> cache.initialCapacity(keysToPreload.size()), mapper, getSingleItem, getMultipleItems);
        this.loadValues(keysToPreload);
    }

    public IndexCache(UnaryOperator<Caffeine<KEY_TYPE, Optional<CACHED_TYPE>>> cacheConfiguration, FunctionWithException<INDEX_TYPE, CACHED_TYPE, StorageException> mapper, FunctionWithException<KEY_TYPE, INDEX_TYPE, StorageException> getSingleItem, FunctionWithException<List<KEY_TYPE>, List<INDEX_TYPE>, StorageException> getMultipleItems) {
        this.mapper = mapper;
        this.getSingleItem = getSingleItem;
        this.getMultipleItems = getMultipleItems;
        Caffeine cacheBuilder = Caffeine.newBuilder();
        this.cache = ((Caffeine)cacheConfiguration.apply(cacheBuilder)).build();
    }

    private Optional<CACHED_TYPE> loadSingleItem(KEY_TYPE key) throws UncheckedStorageException {
        try {
            return this.mapToCacheValue(this.getSingleItem.apply(key));
        }
        catch (StorageException e) {
            throw new UncheckedStorageException(e);
        }
    }

    private Map<KEY_TYPE, Optional<CACHED_TYPE>> loadMultipleItems(Set<? extends KEY_TYPE> keys) throws UncheckedStorageException {
        try {
            ArrayList<KEY_TYPE> keyList = new ArrayList<KEY_TYPE>(keys);
            Collection values = (Collection)this.getMultipleItems.apply(keyList);
            CCSMAssert.isTrue((keys.size() == values.size() ? 1 : 0) != 0, () -> "Expected equal number of keys (%d) and returned values (%d)".formatted(keys.size(), values.size()));
            HashMap result = HashMap.newHashMap(keyList.size());
            CollectionUtils.forEachWithException(keyList, (Collection)values, (key, value) -> result.put(key, this.mapToCacheValue(value)));
            return result;
        }
        catch (StorageException e) {
            throw new UncheckedStorageException(e);
        }
    }

    private Optional<CACHED_TYPE> mapToCacheValue(INDEX_TYPE value) throws StorageException {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(this.mapper.apply(value));
    }

    public void loadValues(List<KEY_TYPE> keys) throws StorageException {
        try {
            this.cache.putAll(this.loadMultipleItems(new HashSet<KEY_TYPE>(keys)));
        }
        catch (UncheckedStorageException e) {
            throw e.getCause();
        }
    }

    public CACHED_TYPE getValue(KEY_TYPE key) throws StorageException {
        try {
            return ((Optional)this.cache.get(key, this::loadSingleItem)).orElse(null);
        }
        catch (UncheckedStorageException e) {
            throw e.getCause();
        }
    }

    public List<CACHED_TYPE> getValues(Collection<KEY_TYPE> keys) throws StorageException {
        try {
            Map values = this.cache.getAll(keys, this::loadMultipleItems);
            ArrayList<Object> result = new ArrayList<Object>(keys.size());
            for (KEY_TYPE key : keys) {
                result.add(((Optional)values.get(key)).orElse(null));
            }
            return result;
        }
        catch (UncheckedStorageException e) {
            throw e.getCause();
        }
    }

    public CacheStats getCacheStats() {
        return this.cache.stats();
    }

    private static class UncheckedStorageException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private UncheckedStorageException(StorageException cause) {
            super(cause);
        }

        @Override
        public synchronized StorageException getCause() {
            return (StorageException)super.getCause();
        }
    }
}

