/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@IndexValueClass
@ExportToTypeScript
public record LogEntryIdentifier(@JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="suffix") long suffix) implements Comparable<LogEntryIdentifier>,
Serializable
{
    private static final int LOG_PROCESS_ID;
    private static final AtomicInteger LOG_SEQUENCE_NUMBER;

    @JsonCreator
    static @Nullable LogEntryIdentifier getInstance(String encoded) {
        if (encoded == null) {
            return null;
        }
        return LogEntryIdentifier.decodeIdentifier(encoded);
    }

    public LogEntryIdentifier withSuffix(long suffix) {
        return new LogEntryIdentifier(this.timestamp, suffix);
    }

    @Override
    @JsonValue
    public String toString() {
        return LogEntryIdentifier.encodeIdentifier(this.timestamp, this.suffix);
    }

    @VisibleForTesting
    public static String encodeIdentifier(long timestamp, long suffix) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(timestamp);
        buffer.putLong(suffix);
        byte[] bytes = buffer.array();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    public static LogEntryIdentifier decodeIdentifier(String encoded) {
        byte[] bytes = Base64.getUrlDecoder().decode(encoded);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long timestamp = buffer.getLong();
        long suffix = buffer.getLong();
        return new LogEntryIdentifier(timestamp, suffix);
    }

    @Override
    public int compareTo(LogEntryIdentifier other) {
        int timestampComparison = Long.compare(this.timestamp, other.timestamp);
        if (timestampComparison != 0) {
            return timestampComparison;
        }
        return Long.compare(this.suffix, other.suffix);
    }

    private static int getLoggerInstanceId() {
        SecureRandom secureRandom = new SecureRandom();
        return secureRandom.nextInt();
    }

    public static long freshLogEntrySuffix() {
        int logSequenceNumber = LOG_SEQUENCE_NUMBER.incrementAndGet();
        return (long)LOG_PROCESS_ID << 32 | (long)logSequenceNumber & 0xFFFFFFFFL;
    }

    public static LogEntryIdentifier freshWithTimestamp(long timestamp) {
        return new LogEntryIdentifier(timestamp, LogEntryIdentifier.freshLogEntrySuffix());
    }

    static {
        LOG_SEQUENCE_NUMBER = new AtomicInteger(0);
        LOG_PROCESS_ID = LogEntryIdentifier.getLoggerInstanceId();
    }
}

