/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.source;

import com.google.common.collect.Iterables;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.metrics.AssessedRange;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.source.DerivedMetricSourceBase;
import com.teamscale.core.metrics.source.MetricAggregationUtils;
import com.teamscale.core.metrics.values.EMetricValueType;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class DoubleAssessorMetricSource
extends DerivedMetricSourceBase {
    private static final long serialVersionUID = 1L;
    private final CodeScopeAware<Integer> valueMetricOffsetPerCodeScope;
    private final CodeScopeAware<Integer> sizeMetricOffsetPerCodeScope;
    private final CodeScopeAware<List<AssessedRange>> rangesPerCodeScope;
    private final Set<CodeScopeName> codeScopesWithDisabledAssessment;

    public DoubleAssessorMetricSource(CodeScopeAware<Integer> valueMetricOffsetPerCodeScope, CodeScopeAware<Integer> sizeMetricOffsetPerCodeScope, CodeScopeAware<List<AssessedRange>> rangesPerCodeScope, Set<CodeScopeName> codeScopesWithDisabledAssessment) {
        this.valueMetricOffsetPerCodeScope = valueMetricOffsetPerCodeScope;
        this.sizeMetricOffsetPerCodeScope = sizeMetricOffsetPerCodeScope;
        this.rangesPerCodeScope = rangesPerCodeScope;
        this.codeScopesWithDisabledAssessment = codeScopesWithDisabledAssessment;
    }

    @Override
    public void init(int ownOffset, MetricDirectorySchema schema) throws ConQATException {
        super.init(ownOffset, schema);
        for (List<AssessedRange> ranges : this.rangesPerCodeScope.getValues()) {
            AssessedRange.checkRanges(ranges);
        }
        DoubleAssessorMetricSource.expectMetricType(ownOffset, schema, EMetricValueType.ASSESSMENT);
        for (CodeScopeName codeScopeName : this.valueMetricOffsetPerCodeScope.getCodeScopeNames()) {
            DoubleAssessorMetricSource.expectMetricType(this.valueMetricOffsetPerCodeScope.getValue(codeScopeName), schema, EMetricValueType.NUMERIC);
            DoubleAssessorMetricSource.expectMetricType(this.sizeMetricOffsetPerCodeScope.getValue(codeScopeName), schema, EMetricValueType.NUMERIC);
        }
    }

    @Override
    public void generateValue(Object[] values, boolean hasChildren, MetricDirectorySchemaEntry schemaEntry, CounterSet<String> codeScopeNames) {
        CCSMAssert.isNotNull(codeScopeNames, (String)("code scope may not be null for schema entry " + schemaEntry.getName()));
        CCSMAssert.isTrue((schemaEntry.getAggregation() != MetricDirectorySchemaEntry.EAggregation.NONE ? 1 : 0) != 0, (String)"Expected aggregation for double metric to be not EAggregation.NONE!");
        if (hasChildren) {
            return;
        }
        if (codeScopeNames.getTotal() != 1) {
            values[this.offset] = null;
            return;
        }
        CodeScopeName codeScopeName = new CodeScopeName((String)Iterables.getOnlyElement((Iterable)codeScopeNames.getKeys()));
        boolean valueMetricDisabled = !this.valueMetricOffsetPerCodeScope.contains(codeScopeName);
        boolean assessmentDisabled = this.codeScopesWithDisabledAssessment.contains(codeScopeName);
        if (valueMetricDisabled || assessmentDisabled) {
            values[this.offset] = null;
            return;
        }
        Object value = values[this.valueMetricOffsetPerCodeScope.getValue(codeScopeName)];
        int sizeMetricOffset = this.sizeMetricOffsetPerCodeScope.getValue(codeScopeName);
        if (value instanceof Double) {
            Assessment assessment = AssessedRange.determineAssessment((Double)value, this.rangesPerCodeScope.getValue(codeScopeName), ETrafficLightColor.RED);
            if (values[sizeMetricOffset] instanceof Double) {
                int size = (int)Math.round((Double)values[sizeMetricOffset]);
                if (size <= 0) {
                    assessment = new Assessment();
                } else {
                    assessment.add(assessment.getDominantColor(), size - 1);
                }
            }
            values[this.offset] = assessment;
        } else {
            values[this.offset] = null;
        }
    }

    @Override
    public Object aggregate(List<Object> values, MetricDirectorySchemaEntry schemaEntry) {
        if (schemaEntry.getAggregation() == MetricDirectorySchemaEntry.EAggregation.NONE) {
            return null;
        }
        return MetricAggregationUtils.aggregateAssessment(values);
    }
}

