/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IBatchStorageMigrator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.ScatteredCollectionIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion155RestructureExternalAnalysisSessionIndex
implements IBatchStorageMigrator {
    private static final int SESSION_ID_LENGTH_IN_BYTES = 37;
    private static final int SESSION_ID_UNIFORM_PATH_PREFIX_LENGTH = 37 + StringUtils.stringToBytes((String)"/").length;
    private static final byte[] OLD_COMMIT_KEY_PREFIX = new byte[]{1};

    @Override
    public void migrate(IStore input, IStore output, IFactory<IStore, StorageException> tempStoreFactory) throws StorageException {
        output = new CompressingStore(output);
        input = new CompressingStore(input);
        MigrateVersion155RestructureExternalAnalysisSessionIndex.migrateCommitToSessionId(input, output);
        MigrateVersion155RestructureExternalAnalysisSessionIndex.migrateSessionDataAndValues(input, output);
        MigrateVersion155RestructureExternalAnalysisSessionIndex.migrateUnscheduledSessions(input, output);
    }

    private static void migrateCommitToSessionId(IStore input, IStore output) throws StorageException {
        PairList entries = new PairList();
        input.scan(OLD_COMMIT_KEY_PREFIX, (key, value) -> {
            PairList pairList = entries;
            synchronized (pairList) {
                entries.add((Object)ByteArrayUtils.removePrefix((byte[])OLD_COMMIT_KEY_PREFIX, (byte[])key), (Object)Arrays.copyOfRange(value, 7, value.length));
            }
        });
        new DelegatingPartitionStore(output, "c").put(entries);
    }

    private static void migrateSessionDataAndValues(IStore input, IStore output) throws StorageException {
        OldLayoutSessionCollectingCallback callback = new OldLayoutSessionCollectingCallback();
        input.scan(StringUtils.stringToBytes((String)"S"), (IKeyValueCallback)callback);
        new DelegatingPartitionStore(output, "s").put(callback.getSessionInfoEntries());
        for (Map.Entry<String, PairList<byte[], byte[]>> entry : callback.getSessionSpecificValues().entrySet()) {
            DelegatingPartitionStore store = new DelegatingPartitionStore(output, "v" + entry.getKey());
            for (Pair pair : entry.getValue()) {
                store.put(MigrateVersion155RestructureExternalAnalysisSessionIndex.migrateImportInfos((byte[])pair.getFirst(), (byte[])pair.getSecond()));
            }
        }
    }

    private static PairList<byte[], byte[]> migrateImportInfos(byte[] key, byte[] value) throws StorageException {
        List<byte[]> importInfos = MigrateVersion155RestructureExternalAnalysisSessionIndex.extractExternalAnalysisImportInfos(value);
        InMemoryStore resultStore = new InMemoryStore();
        ScatteredCollectionIndex index = ScatteredCollectionIndex.of((IStore)resultStore, (ISerializer)ISerializer.identity(), (int)1);
        index.put(key, importInfos);
        PairList resultList = new PairList();
        resultStore.scan(new byte[0], (IKeyValueCallback)new KeyValueCollectingCallback(resultList));
        return resultList;
    }

    private static List<byte[]> extractExternalAnalysisImportInfos(byte[] value) throws StorageException {
        try {
            SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
            ArrayList<byte[]> importInfos = new ArrayList<byte[]>();
            for (SerializedObject rootEntity : entityPool.getRootEntities(SerializedObject.class)) {
                MigrateVersion155RestructureExternalAnalysisSessionIndex.assertExactType(rootEntity, "com.teamscale.index.external.input.info.ExternalAnalysisImportInfos");
                SerializedObject infosListEntity = (SerializedObject)entityPool.getEntity(((Integer)rootEntity.getFieldValue("infos")).intValue(), SerializedObject.class);
                MigrateVersion155RestructureExternalAnalysisSessionIndex.assertExactType(infosListEntity, "java.util.ArrayList");
                List postFieldData = infosListEntity.getFieldSet(0).getPostFieldData();
                for (Object entityHandle : postFieldData.subList(1, postFieldData.size())) {
                    SerializedObject externalAnalysisImportInfoEntity = (SerializedObject)entityPool.getEntity(((Integer)entityHandle).intValue(), SerializedObject.class);
                    MigrateVersion155RestructureExternalAnalysisSessionIndex.assertType(externalAnalysisImportInfoEntity, "com.teamscale.index.external.input.info.ExternalAnalysisImportInfo");
                    importInfos.add(SerializedEntitySerializer.serializeToBytes(List.of(externalAnalysisImportInfoEntity)));
                }
            }
            return importInfos;
        }
        catch (IOException e) {
            throw new StorageException("Unable to extract ExternalAnalysisImportInfo instances", (Throwable)e);
        }
    }

    private static void assertType(SerializedObject entity, String expectedTypeName) throws IOException {
        if (entity.getPlainClassHierarchy().stream().noneMatch(clazz -> expectedTypeName.equals(clazz.getName()))) {
            throw new AssertionError((Object)"Encountered unexpected type (%s), expected: %s".formatted(entity.getSerializedClass().getName(), expectedTypeName));
        }
    }

    private static void assertExactType(SerializedObject entity, String expectedTypeName) throws IOException {
        if (!expectedTypeName.equals(entity.getSerializedClass().getName())) {
            throw new AssertionError((Object)"Encountered unexpected type (%s), expected: %s".formatted(entity.getSerializedClass().getName(), expectedTypeName));
        }
    }

    private static void migrateUnscheduledSessions(IStore input, IStore output) throws StorageException {
        byte[] unscheduledSessionList = input.get(StringUtils.stringToBytes((String)"##all-sessions##"));
        if (unscheduledSessionList == null) {
            return;
        }
        List unscheduledSessions = (List)((Object)StorageUtils.deserialize((byte[])unscheduledSessionList));
        KeysOnlyIndex unscheduledSessionIndex = new KeysOnlyIndex((IStore)new DelegatingPartitionStore(output, "u"));
        unscheduledSessionIndex.storeKeys(unscheduledSessions);
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V155;
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.PROJECT;
    }

    @Override
    public String getStoreName() {
        return "external-analysis-session";
    }

    @ThreadSafe
    private static class OldLayoutSessionCollectingCallback
    implements IKeyValueCallback {
        private final PairList<byte[], byte[]> sessionInfoEntries = new PairList();
        private final Map<String, PairList<byte[], byte[]>> sessionSpecificValues = new HashMap<String, PairList<byte[], byte[]>>();

        private OldLayoutSessionCollectingCallback() {
        }

        public void callback(byte[] key, byte[] value) {
            if (key.length == 37) {
                this.handleSessionInfoEntry(key, value);
            } else {
                this.handleImportInfosEntry(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSessionInfoEntry(byte[] key, byte[] value) {
            PairList<byte[], byte[]> pairList = this.sessionInfoEntries;
            synchronized (pairList) {
                this.sessionInfoEntries.add((Object)key, (Object)value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleImportInfosEntry(byte[] key, byte[] value) {
            String sessionId = StringUtils.bytesToString((byte[])key, (int)0, (int)37);
            byte[] uniformPath = Arrays.copyOfRange(key, SESSION_ID_UNIFORM_PATH_PREFIX_LENGTH, key.length);
            Map<String, PairList<byte[], byte[]>> map = this.sessionSpecificValues;
            synchronized (map) {
                this.sessionSpecificValues.computeIfAbsent(sessionId, ignored -> new PairList()).add((Object)uniformPath, (Object)value);
            }
        }

        public PairList<byte[], byte[]> getSessionInfoEntries() {
            return this.sessionInfoEntries;
        }

        public Map<String, PairList<byte[], byte[]>> getSessionSpecificValues() {
            return this.sessionSpecificValues;
        }
    }
}

