/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.tfs.ITfsConnection;
import com.teamscale.core.tfs.TfsConnection;
import com.teamscale.core.tfs.TfsException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.jetbrains.annotations.TestOnly;

public final class TfsConnectionFactory {
    private static final ThreadLocal<FunctionWithException<ExternalCredentials, ITfsConnection, TfsException>> CONNECTION_CONSTRUCTOR = ThreadLocal.withInitial(() -> TfsConnection::new);

    public static ITfsConnection createWithExternalCredentials(ExternalCredentials externalCredentials) throws TfsException {
        return (ITfsConnection)CONNECTION_CONSTRUCTOR.get().apply((Object)externalCredentials);
    }

    @TestOnly
    public static AutoCloseable overwriteConstructionForThread(FunctionWithException<ExternalCredentials, ITfsConnection, TfsException> creationImplementation) {
        CONNECTION_CONSTRUCTOR.set(creationImplementation);
        return CONNECTION_CONSTRUCTOR::remove;
    }

    private TfsConnectionFactory() {
    }
}

