/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.shutdown.ShutdownManager;
import com.teamscale.service.admin.ServerRenderedPageServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="api/shutdown")
public class TeamscaleShutdownService
extends ServerRenderedPageServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Shutdown Teamscale", description="Provides an UI to issue a Teamscale shutdown request.", tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/html"})
    public String getTeamscaleShutdownPage() {
        return this.buildHttpFormPage();
    }

    @POST
    @Operation(summary="Shutdown Teamscale", description="Allows to shut down a running Teamscale instance", tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void shutdown(@Parameter(description="The exit code of the process. By convention, a nonzero status code indicates abnormal termination.") @FormParam(value="exitCode") @DefaultValue(value="0") int exitCode) {
        LOGGER.warn("User requested shutdown of instance with exit code " + exitCode);
        ShutdownManager.getInstance().shutdown(exitCode);
    }
}

