/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogFileUtils;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.commits.ECommitAttribute;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.RepositoryLogFilterBase;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class RepositoryLogFilter
extends RepositoryLogFilterBase {
    static final String FILTER_USERS_PARAMETER = "users";
    @Parameter(description="User names to filter for.")
    @QueryParam(value="users")
    private Set<String> users;
    @Parameter(description="Group names to filter for.")
    @QueryParam(value="groups")
    private Set<String> groups;
    @Parameter(description="Whether we want to filter for spec items or code.")
    @QueryParam(value="specItemEntriesOnly")
    private boolean specItemEntriesOnly;
    @Parameter(description="Commit messages to filter for.")
    @QueryParam(value="commit-messages")
    private Set<String> commitMessages;
    @Hidden
    private Set<String> filteredRevisions;
    @Hidden
    private Set<String> resolvedUsers;
    @Hidden
    private boolean doFilterByDataPrivacySettings = false;
    @Hidden
    private GlobalStorageSystem storageSystem;
    @Hidden
    private ServicePermissions permissions;
    @Hidden
    private User user;
    @Hidden
    private UserAliasLookup userAliasLookup;
    @Hidden
    private LoadingCache<String, Boolean> userCache;
    @Hidden
    private LoadingCache<String, Boolean> groupCache;

    public RepositoryLogFilter() {
    }

    public RepositoryLogFilter(UserAliasLookup userAliasLookup) {
        this((Set<String>)CollectionUtils.emptySet(), (Set<String>)CollectionUtils.emptySet(), userAliasLookup, (Set<String>)CollectionUtils.emptySet());
    }

    public RepositoryLogFilter(UserAliasLookup userAliasLookup, Set<ECommitType> commitTypes) {
        this((Set<String>)CollectionUtils.emptySet(), (Set<String>)CollectionUtils.emptySet(), userAliasLookup, (Set<String>)CollectionUtils.emptySet());
        this.commitTypes = commitTypes;
    }

    RepositoryLogFilter(Set<String> filteredRevisions, final Set<String> users, UserAliasLookup userAliasLookup, final Set<String> groups) {
        this.filteredRevisions = filteredRevisions;
        this.userAliasLookup = userAliasLookup;
        this.resolvedUsers = CollectionUtils.mapToSet(users, alias -> userAliasLookup.resolveUser(alias).map(User::getFullName).orElse((String)alias));
        this.commitTypes = new HashSet();
        this.groups = groups;
        this.users = users;
        this.userCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Boolean>(this){

            public @NonNull Boolean load(@NonNull String key) {
                return users.stream().anyMatch(userFilter -> StringUtils.containsIgnoreCase((String)key, (String)userFilter));
            }
        });
        this.groupCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Boolean>(this){

            public @NonNull Boolean load(@NonNull String key) {
                return groups.stream().anyMatch(groupFilter -> StringUtils.containsIgnoreCase((String)key, (String)groupFilter));
            }
        });
    }

    public boolean isSpecItemEntriesOnly() {
        return this.specItemEntriesOnly;
    }

    public void setFilteringOptions(UserAliasLookup userAliasLookup) {
        this.setFilteringOptions((Set<String>)CollectionUtils.emptySet(), userAliasLookup, "");
    }

    public void setFilteringOptions(Set<String> filteredRevisions, UserAliasLookup userAliasLookup, String filteringBranchName) {
        this.filteredRevisions = filteredRevisions;
        this.userAliasLookup = userAliasLookup;
        this.filteringBranchName = filteringBranchName;
        this.resolvedUsers = CollectionUtils.mapToSet(this.users, alias -> userAliasLookup.resolveUser(alias).map(User::getFullName).orElse((String)alias));
        if (this.commitTypes.isEmpty()) {
            this.commitTypes.addAll(CollectionUtils.asHashSet((Object[])ECommitType.values()));
        }
        this.userCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Boolean>(){

            public @NonNull Boolean load(@NonNull String key) {
                return RepositoryLogFilter.this.users.stream().anyMatch(userFilter -> StringUtils.containsIgnoreCase((String)key, (String)userFilter));
            }
        });
        this.groupCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Boolean>(){

            public @NonNull Boolean load(@NonNull String key) {
                return RepositoryLogFilter.this.groups.stream().anyMatch(groupFilter -> StringUtils.containsIgnoreCase((String)key, (String)groupFilter));
            }
        });
    }

    public void setPrivacyRelatedFilteringInfo(boolean filterByDataPrivacySettings, GlobalStorageSystem storageSystem, ServicePermissions permissions, User user) {
        this.doFilterByDataPrivacySettings = filterByDataPrivacySettings;
        this.storageSystem = storageSystem;
        this.permissions = permissions;
        this.user = user;
    }

    public List<ExtendedRepositoryLogEntry> filter(List<ExtendedRepositoryLogEntry> logEntries) throws StorageException {
        List relevantEntries = this.getRelevantLogEntries(logEntries);
        if (this.commitAttribute == null) {
            return relevantEntries;
        }
        return switch (this.commitAttribute) {
            default -> throw new MatchException(null, null);
            case ECommitAttribute.IS_ANY_COMMIT -> relevantEntries;
            case ECommitAttribute.HAS_FINDINGS_CHURN -> CollectionUtils.filter(relevantEntries, entry -> entry.findingChurnCount().hasFindingsChurn());
            case ECommitAttribute.HAS_ALERTS -> CollectionUtils.filter((Collection)relevantEntries, entry -> entry.alertsCount() > 0);
        };
    }

    private List<ExtendedRepositoryLogEntry> getRelevantLogEntries(List<ExtendedRepositoryLogEntry> logEntries) throws StorageException {
        List result = CollectionUtils.filterNullEntries(logEntries);
        this.removeFilteredRevisions(result);
        this.removeLogEntriesOfUnmatchedAuthors(result);
        this.removeLogEntriesOfAuthorsOfUnmatchedGroups(result);
        this.removeCommitsFromUnmatchedTypes(result);
        this.removeLogEntriesOfUnmatchedCommitMessages(result);
        this.excludeCommitsOfOtherBranches(result);
        return this.filterByDataPrivacySettings(result);
    }

    private void removeFilteredRevisions(List<ExtendedRepositoryLogEntry> logEntries) {
        if (logEntries.isEmpty()) {
            return;
        }
        logEntries.removeIf(logEntry -> this.filteredRevisions.contains(String.valueOf(logEntry.logEntry().getTimestamp())));
    }

    private void removeLogEntriesOfUnmatchedCommitMessages(List<ExtendedRepositoryLogEntry> logEntries) {
        if (this.commitMessages == null || this.commitMessages.isEmpty()) {
            return;
        }
        logEntries.removeIf(logEntry -> this.commitMessages.stream().anyMatch(commitMessage -> !StringUtils.containsIgnoreCase((String)StringUtils.emptyIfNull((String)logEntry.getMessage()), (String)commitMessage)));
    }

    private void removeLogEntriesOfUnmatchedAuthors(List<ExtendedRepositoryLogEntry> logEntries) {
        if (this.users.isEmpty()) {
            return;
        }
        logEntries.removeIf(logEntry -> {
            String author = logEntry.getAuthor();
            User user = logEntry.logEntry().getResolvedAuthor();
            if (user != null && ((Boolean)this.userCache.getUnchecked((Object)user.getUsername())).booleanValue()) {
                return false;
            }
            if (this.resolvedUsers.contains(this.userAliasLookup.resolveAuthorOf((IRepositoryLogEntry)logEntry).map(User::getFullName).orElse(author))) {
                return false;
            }
            return (Boolean)this.userCache.getUnchecked((Object)author) == false;
        });
    }

    private void removeLogEntriesOfAuthorsOfUnmatchedGroups(List<ExtendedRepositoryLogEntry> logEntries) {
        if (this.groups.isEmpty()) {
            return;
        }
        logEntries.removeIf(logEntry -> {
            User user = logEntry.logEntry().getResolvedAuthor();
            if (user != null) {
                Set groups = user.getGroupIds();
                return groups.stream().noneMatch(group -> (Boolean)this.groupCache.getUnchecked(group));
            }
            return true;
        });
    }

    private List<ExtendedRepositoryLogEntry> filterByDataPrivacySettings(List<ExtendedRepositoryLogEntry> logEntries) throws StorageException {
        if (!this.doFilterByDataPrivacySettings || logEntries.isEmpty()) {
            return logEntries;
        }
        return RepositoryLogFileUtils.applyDataPrivacyFilterToLog(logEntries, (GlobalStorageSystem)this.storageSystem, (ServicePermissions)this.permissions, (User)this.user, (UserAliasLookup)this.userAliasLookup);
    }
}

