/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.google.common.collect.Iterables;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.findings.calculation.SpecItemUtils;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.resource.VirtualCodePathUtils;
import com.teamscale.service.base.TimeRangeResourceServiceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class DeltaAnalysisServiceBase
extends TimeRangeResourceServiceBase {
    protected List<CommitDescriptor> getRelevantCommits(CommitDescriptor startCommit, CommitDescriptor endCommit, UniformPath uniformPath, boolean onlySpecItemFindings) throws StorageException {
        if (onlySpecItemFindings) {
            return this.getSpecItemCommits(startCommit, endCommit, uniformPath);
        }
        return this.getCodeCommits(startCommit, endCommit, uniformPath);
    }

    private List<CommitDescriptor> getCodeCommits(CommitDescriptor startCommit, CommitDescriptor endCommit, UniformPath uniformPath) throws StorageException {
        Set<UniformPath> uniformPaths = this.resolveVirtualPath(startCommit, endCommit, uniformPath);
        return this.getCommits(startCommit, endCommit, uniformPaths);
    }

    private List<CommitDescriptor> getCommits(CommitDescriptor startCommit, CommitDescriptor endCommit, Set<UniformPath> uniformPaths) throws StorageException {
        CommitDescriptorIndex commitDescriptorIndex = this.openCommitDescriptorIndex();
        Optional actualEndCommit = commitDescriptorIndex.getFirstActualCommitBeforeOrAt(endCommit, startCommit.getTimestamp());
        if (actualEndCommit.isEmpty()) {
            return Collections.emptyList();
        }
        List commits = commitDescriptorIndex.getCommitHistoryWithFirstParentCommits((CommitDescriptor)actualEndCommit.get(), startCommit.getTimestamp());
        RepositoryLogFileIndex logFileIndex = this.openProjectIndex(RepositoryLogFileIndex.class, null);
        if (uniformPaths.size() == 1) {
            return logFileIndex.getCodePathsByCommits(commits, (UniformPath)Iterables.getOnlyElement(uniformPaths)).getKeys().stream().sorted().toList();
        }
        Predicate includedPredicate = VirtualCodePathUtils.isIncludedInTree(uniformPaths);
        HashSet<CommitDescriptor> result = new HashSet<CommitDescriptor>();
        List logFileEntries = logFileIndex.getEntriesByCommits(commits);
        for (RepositoryLogFileEntry logFileEntry : logFileEntries) {
            if (!includedPredicate.test(logFileEntry.getUniformPath())) continue;
            result.add(logFileEntry.getCommit());
        }
        return new ArrayList<CommitDescriptor>(result);
    }

    private List<CommitDescriptor> getSpecItemCommits(CommitDescriptor startCommit, CommitDescriptor endCommit, UniformPath uniformPath) throws StorageException {
        Set specItemBranches = SpecItemUtils.getPossibleSpecItemBranches((String)endCommit.getBranchName(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId(), (IndexLayer)this.getIndexLayer());
        ArrayList<CommitDescriptor> commitsForAllSpecItemBranches = new ArrayList<CommitDescriptor>();
        for (String specItemBranch : specItemBranches) {
            CommitDescriptor branchAdjustedStartCommit = new CommitDescriptor(specItemBranch, startCommit.getTimestamp());
            CommitDescriptor branchAdjustedEndCommit = new CommitDescriptor(specItemBranch, endCommit.getTimestamp());
            commitsForAllSpecItemBranches.addAll(this.getCommits(branchAdjustedStartCommit, branchAdjustedEndCommit, Set.of(uniformPath)));
        }
        return commitsForAllSpecItemBranches;
    }

    private Set<UniformPath> resolveVirtualPath(CommitDescriptor startCommit, CommitDescriptor endCommit, UniformPath uniformPath) throws StorageException {
        return CollectionUtils.unionSet(this.resolveVirtualPath(startCommit, uniformPath), (Collection[])new Collection[]{this.resolveVirtualPath(endCommit, uniformPath)});
    }

    private Set<UniformPath> resolveVirtualPath(CommitDescriptor commit, UniformPath uniformPath) throws StorageException {
        return VirtualCodePathUtils.resolveToCodePaths((UniformPath)uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)HistoryAccessOption.readCommit((CommitDescriptor)commit));
    }
}

