/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.external.input.AnalysisProfileUpdater;
import com.teamscale.index.upload.IExternalToolRule;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.core.core.ConQATException;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;

public abstract class FindingDescriptorCreationServiceBase<R extends IExternalToolRule>
extends ApiBase {
    protected static final String ANALYSIS_PROFILE_PARAMETER = "analysis-profile";
    public static final String ANALYSIS_PROFILE_PARAMETER_DESCRIPTION = "The name of the analysis profile to be updated. It cannot be null.";

    protected void doProcess(List<FormDataBodyPart> reports, String analysisProfileName) throws ConQATException, ProjectConfigurationException {
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfile analysisProfile = analysisProfileIndex.getProfile(analysisProfileName);
        if (analysisProfile == null) {
            throw new NotFoundException("No such analysis profile: " + analysisProfileName);
        }
        List<IExternalToolRule> rules = this.getRulesFromReports(reports);
        AnalysisProfileUpdater updater = new AnalysisProfileUpdater(this.getIndexLayer());
        updater.updateAnalysisProfiles(this.getTool(), rules, List.of(analysisProfile));
    }

    private List<IExternalToolRule> getRulesFromReports(List<FormDataBodyPart> reports) throws ConQATException {
        HashMap rules = new HashMap();
        for (FormDataBodyPart report : reports) {
            this.parseReport(report.getValue(), rules);
        }
        return new ArrayList<IExternalToolRule>(rules.values());
    }

    protected abstract void parseReport(String var1, Map<String, R> var2) throws ConQATException;

    protected abstract EAnalysisTool getTool();
}

