/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistCommit;
import com.teamscale.index.blacklisting.FindingBlacklistCommitsIndex;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingBlacklistEventIndex;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.blacklisting.FindingBlacklistStagingIndex;
import com.teamscale.index.blacklisting.FindingExclusionApprovalOption;
import com.teamscale.index.blacklisting.UserResolvedFindingBlacklistInfo;
import com.teamscale.index.findings.calculation.ExtendedTrackedFindingUtils;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.findings.calculation.SpecItemUtils;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.findings.EFindingBlacklistOperation;
import com.teamscale.service.findings.FindingBlacklistRequestBody;
import com.teamscale.service.findings.FindingsBlacklistServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/findings/flagged")
public class FlaggedFindingsService
extends FindingsBlacklistServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get flagged findings", description="Returns all flagged findings for a given project.", tags={"Findings"})
    public List<FindingBlacklistInfo> getFlaggedFindings(@Parameter(description="Key of a precomputed (using the \"merge-requests/parent-info\" endpoint) merge-base info. Should be provided in case the finding delta is requested for a (possible) merge request. ") @QueryParam(value="merge-base-cache-key") String mergeBaseKey, @Parameter(description="Commit denoting the start of the flagged finding interval, or the source commit in case of a (possible) merge. Must be present when \"merge-base-cache-key\" is provided.") @QueryParam(value="from") UnresolvedCommitDescriptor from, @Parameter(description="Commit denoting the end of the flagged finding interval, or the target commit in case of a (possible) merge.", required=true) @QueryParam(value="to") UnresolvedCommitDescriptor to, @Parameter(description="If this is true, only spec item findings are to be shown.") @QueryParam(value="only-spec-item-findings") @DefaultValue(value="false") boolean onlySpecItemFindings) throws StorageException {
        if (onlySpecItemFindings) {
            return this.getFlaggedSpecItemFindingInfos(from, to);
        }
        return this.getBlacklistedFindings(mergeBaseKey, from, to, null);
    }

    @GET
    @Path(value="including-outside-interval")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get flagged findings including of findings created outside the interval", description="Returns all flagged findings for a given project. In comparison to the other methods this also includes flaggings that were created outside the interval but changed in the interval. This affects flagging changes of findings that were created outside the interval.", tags={"Findings"})
    public List<ExtendedTrackedFinding> getFlaggedFindingsIncludingOutsideInterval(@Parameter(description="Commit denoting the start of the flagged finding interval, or the source commit in case of a (possible) merge. Must be present when \"merge-base-cache-key\" is provided.") @QueryParam(value="from") UnresolvedCommitDescriptor from, @Parameter(description="Commit denoting the end of the flagged finding interval, or the target commit in case of a (possible) merge.", required=true) @QueryParam(value="to") UnresolvedCommitDescriptor to) throws StorageException {
        CommitDescriptor resolvedTo = this.resolve(to);
        Collection<FindingBlacklistInfo> fromFindings = this.getAllFindingBlacklistInfos(from);
        Collection<FindingBlacklistInfo> toFindings = this.getAllFindingBlacklistInfos(to);
        Map difference = CollectionUtils.difference(FindingBlacklistInfo::getFindingId, toFindings, (Collection[])new Collection[]{fromFindings}).stream().collect(Collectors.toMap(FindingBlacklistInfo::getFindingId, Function.identity()));
        FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(this.serviceInfo.getPrimaryPublicId(), (ProjectStorageSystem)this.getProjectStorageSystem(), this.getIndexLayer());
        IFindingsRetriever findingsRetriever = IFindingsRetriever.getFindingsRetriever((boolean)false, (boolean)false, (String)resolvedTo.getBranchName(), (FindingsCalculationInfo)calculationInfo);
        List flaggedFindings = CollectionUtils.filter((Collection)findingsRetriever.getFindings(difference.values().stream().map(FindingBlacklistInfo::getFindingId).toList(), resolvedTo), Objects::nonNull);
        return ExtendedTrackedFindingUtils.fromTrackedFindings((List)flaggedFindings, (FindingsCalculationInfo)calculationInfo, difference);
    }

    @GET
    @Path(value="{finding}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Gets flagging information for a finding.", description="Returns the flagging information for the finding with given identifier.", tags={"Findings"})
    @ApiResponse(responseCode="204", description="If there is no flagging information for this finding")
    public UserResolvedFindingBlacklistInfo getFlaggedFindingInfo(@Parameter(description="Id of the finding the information is requested for.") @PathParam(value="finding") String findingId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws BadRequestException, StorageException {
        return this.getBlacklistedFindingInfo(findingId, commit);
    }

    @GET
    @Path(value="ids")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get identifiers of flagged findings", description="Returns identifiers of all flagged findings for a given project.", tags={"Findings"})
    public List<String> getFlaggedFindingIds(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        return this.getBlacklistedFindingIds(commit);
    }

    @POST
    @Path(value="with-ids")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get flagging information for findings.", description="Returns flagging information for the given findings.", tags={"Findings"}, responses={@ApiResponse(responseCode="400", description="One of the filter options is invalid.")})
    public List<@NonNull FindingBlacklistInfo> getFlaggedFindingsInfos(@RequestBody List<String> findingIds, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @Parameter(description="If this is true, only spec item findings are to be shown.") @QueryParam(value="only-spec-item-findings") @DefaultValue(value="false") boolean onlySpecItemFindings) throws BadRequestException, StorageException {
        if (onlySpecItemFindings) {
            return this.getFlaggedSpecItemFindingInfos(findingIds, commit);
        }
        return this.getFlaggedFindingsInfos(findingIds, commit, null);
    }

    @PUT
    @PublicApi(since=ETeamscaleVersion.VERSION_8_5_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Flags/unflags findings", description="Flags/unflags the given findings with the given flagging type.", responses={@ApiResponse(responseCode="400", description="Operation is performed on unknown branch."), @ApiResponse(responseCode="400", description="Requested finding does not belong to the flagged findings."), @ApiResponse(responseCode="404", description="Requested finding does not exist.")}, tags={"Findings"})
    public void flagFindings(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Request operation to perform (e.g. add or remove flagging information).", required=true) @QueryParam(value="operation") EFindingBlacklistOperation operation, @Parameter(description="The type of flagging (optional for an unflag operation, findings of both types will be unflagged)") @QueryParam(value="type") EFindingBlacklistType blacklistType, @RequestBody(required=true) FindingBlacklistRequestBody findingBlacklistRequestBody) throws StorageException, BadRequestException, NotFoundException {
        this.performBlacklistingOperation(commit.getBranchName(), operation, findingBlacklistRequestBody, blacklistType);
    }

    @POST
    @Path(value="pending/resolve")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Approve or reject pending findings exclusion", description="Approves or rejects the pending exclusion for the provided findings", tags={"Findings"})
    public void resolvePendingFindingsExclusion(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @RequestBody ResolvePendingFindingsExclusionRequestBody body) throws StorageException {
        this.checkNonEmptyRationale(body.rationale());
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readHead((String)this.resolve(commit).getBranchName());
        List findings = this.openProjectIndex(TrackedFindingsByIdIndex.class, historyAccessOption).getFindings(body.findingIds());
        List blacklistInfos = this.openProjectIndex(FindingBlacklistIndex.class, historyAccessOption).getBlacklistInfos(body.findingIds());
        this.checkResolvePendingFindingsExclusionPermission(findings, blacklistInfos);
        List<FindingBlacklistEvent> events = this.createResolveEvents(findings, blacklistInfos, body.rationale(), body.approve());
        this.createFlaggingCommitAndSchedule(historyAccessOption.getBranchName(), events);
    }

    private List<FindingBlacklistEvent> createResolveEvents(List<TrackedFinding> findings, List<FindingBlacklistInfo> blacklistInfos, String rationale, boolean approve) {
        String username = this.getUser().getUsername();
        long approvedAt = DateTimeUtils.millisNow();
        ArrayList<FindingBlacklistEvent> events = new ArrayList<FindingBlacklistEvent>(findings.size());
        for (Pair pair : CollectionUtils.zip(findings, blacklistInfos)) {
            TrackedFinding finding = (TrackedFinding)pair.getFirst();
            FindingBlacklistInfo blacklistInfo = (FindingBlacklistInfo)pair.getSecond();
            FindingBlacklistEvent event = approve ? FindingBlacklistEvent.createAddedEvent((String)finding.getId(), (String)finding.getMessage(), (String)username, (String)finding.getLocation().getUniformPath(), (FindingBlacklistInfo)blacklistInfo.cloneWithApproval(username, approvedAt, rationale)) : FindingBlacklistEvent.createRemovedEvent((String)finding.getId(), (String)finding.getMessage(), (String)username, (String)finding.getLocation().getUniformPath(), (FindingBlacklistInfo)blacklistInfo.cloneWithRejection(username, approvedAt, rationale));
            events.add(event);
        }
        return events;
    }

    private void checkResolvePendingFindingsExclusionPermission(List<TrackedFinding> findings, List<FindingBlacklistInfo> blacklistInfos) throws StorageException {
        List<EProjectPermission> requiredPermissions = findings.stream().map(finding -> {
            ETrafficLightColor selector0$temp = finding.getAssessment();
            int index$1 = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RED", "YELLOW"}, (ETrafficLightColor)selector0$temp, index$1)) {
                case 0 -> EProjectPermission.APPROVE_RED_FINDINGS_EXCLUSION;
                case 1 -> EProjectPermission.APPROVE_YELLOW_FINDINGS_EXCLUSION;
                default -> throw new UnsupportedOperationException();
            };
        }).distinct().toList();
        for (EProjectPermission permission : requiredPermissions) {
            this.getPermissions().checkProjectPermission(permission);
        }
        if (!FindingExclusionApprovalOption.getInstance((ProjectOptionIndex)this.openProjectIndex(ProjectOptionIndex.class, null)).isAllowSelfApproval()) {
            String username = this.getUser().getUsername();
            for (FindingBlacklistInfo blacklistInfo : blacklistInfos) {
                if (!blacklistInfo.getUser().equals(username)) continue;
                throw new BadRequestException("Self-approval of pending finding exclusion is not allowed");
            }
        }
    }

    @GET
    @Path(value="{findingId}/events")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get exclusion events", description="Returns all events in which the exclusion information for the provided finding was changed.", tags={"Findings"})
    public List<ExclusionEventDto> getExclusionEvents(@PathParam(value="findingId") String findingId, @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        Set commits = this.openProjectIndex(FindingBlacklistCommitsIndex.class, null).getCommits(findingId);
        ArrayList<ExclusionEventDto> events = new ArrayList<ExclusionEventDto>(commits.size());
        UserAliasLookup aliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        for (CommitDescriptor resolvedCommit : commits) {
            FindingBlacklistEventIndex eventIndex;
            FindingBlacklistEvent event;
            if (resolvedCommit.getTimestamp() > commit.getTimestamp() || (event = (eventIndex = this.openProjectIndex(FindingBlacklistEventIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)resolvedCommit))).getEvent(findingId)) == null) continue;
            ExclusionEventDto exclusionEventDto = ExclusionEventDto.of(event, resolvedCommit, aliasLookup);
            events.add(exclusionEventDto);
        }
        return events;
    }

    @GET
    @Path(value="{finding}/unprocessed")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get unprocessed finding exclusions", description="Returns any unprocessed finding exclusions for the given commits, or null", tags={"Findings"})
    public UserResolvedFindingBlacklistInfo getUnprocessedFindingExclusion(@Parameter(description="Id of the finding the information is requested for.") @PathParam(value="finding") String findingId, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        List<CommitDescriptor> unprocessedCommits = this.resolveUnprocessedBranchingLayerCommits(this.resolve(commit), FindingBlacklistStagingIndex.class);
        if (unprocessedCommits.isEmpty()) {
            return null;
        }
        for (CommitDescriptor unprocessedCommit : unprocessedCommits) {
            Optional<FindingBlacklistEvent> lastEventForFindingId;
            FindingBlacklistCommit commitInfo = (FindingBlacklistCommit)this.openProjectIndex(FindingBlacklistStagingIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)unprocessedCommit)).getCommitInfo();
            if (commitInfo == null || (lastEventForFindingId = commitInfo.getBlacklistEvents().stream().filter(event -> event.getFindingId().equals(findingId)).findAny()).isEmpty() || lastEventForFindingId.get().getBlacklistInfo().isEmpty()) continue;
            return new UserResolvedFindingBlacklistInfo((FindingBlacklistInfo)lastEventForFindingId.get().getBlacklistInfo().get(), lastEventForFindingId.get().getType(), UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()));
        }
        return null;
    }

    private List<CommitDescriptor> resolveUnprocessedBranchingLayerCommits(CommitDescriptor headCommit, Class<? extends IStorageIndex> indexClass) throws StorageException {
        long timestamp = this.openProjectIndex(CommitDescriptorIndex.class, null).getFirstActualCommitBeforeOrAt(headCommit, 0L).map(CommitDescriptor::getTimestamp).orElse(0L);
        return this.getProjectStorageSystem().openBranchingLayer(indexClass).getCommitInfosForBranch(headCommit.getBranchName()).stream().filter(commit -> commit.getTimestamp() > timestamp).map(IBranchCommitInfo::toCommitDescriptor).sorted(Comparator.comparingLong(CommitDescriptor::getTimestamp).reversed()).toList();
    }

    private @NonNull List<FindingBlacklistInfo> getFlaggedSpecItemFindingInfos(UnresolvedCommitDescriptor from, UnresolvedCommitDescriptor to) throws StorageException {
        Set branches = SpecItemUtils.getPossibleSpecItemBranches((String)from.getBranchName(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId(), (IndexLayer)this.serviceInfo.getIndexLayer());
        branches.add(to.getBranchName());
        ArrayList<FindingBlacklistInfo> flaggedFindings = new ArrayList<FindingBlacklistInfo>();
        for (String branch : branches) {
            UnresolvedCommitDescriptor target = new UnresolvedCommitDescriptor(branch, to.getTimestamp());
            List<FindingBlacklistInfo> flaggedFindingsForBranch = this.getFilteredFindingBlacklistInfos(target, from.getTimestamp(), null);
            flaggedFindings.addAll(flaggedFindingsForBranch);
        }
        return new ArrayList<FindingBlacklistInfo>(CollectionUtils.difference(FindingBlacklistInfo::getFindingId, flaggedFindings, (Collection[])new Collection[]{this.getFilteredFindingBlacklistInfos(from, from.getTimestamp(), null)}));
    }

    private @NonNull List<FindingBlacklistInfo> getFlaggedSpecItemFindingInfos(List<String> findingIds, UnresolvedCommitDescriptor from) throws StorageException {
        Set branches = SpecItemUtils.getPossibleSpecItemBranches((String)from.getBranchName(), (PublicProjectId)this.serviceInfo.getPrimaryPublicId(), (IndexLayer)this.serviceInfo.getIndexLayer());
        ArrayList<FindingBlacklistInfo> result = new ArrayList<FindingBlacklistInfo>();
        for (String branch : branches) {
            UnresolvedCommitDescriptor commit = new UnresolvedCommitDescriptor(branch, from.getTimestamp());
            FindingBlacklistIndex blacklistIndex = this.openProjectIndex(FindingBlacklistIndex.class, this.determineHistoryOption(commit));
            List<FindingBlacklistInfo> values = blacklistIndex.getBlacklistInfos(findingIds).stream().filter(Objects::nonNull).toList();
            result.addAll(values);
        }
        return result;
    }

    public record ResolvePendingFindingsExclusionRequestBody(List<String> findingIds, boolean approve, @Nullable String rationale) {
    }

    public record ExclusionEventDto(@Nullable EFindingBlacklistType type, long timestamp, String username, @Nullable User resolvedUser, FindingBlacklistEvent.EExtendedBlacklistChangeType action, String rationale, CommitDescriptor commit) {
        static ExclusionEventDto of(FindingBlacklistEvent event, CommitDescriptor commit, UserAliasLookup aliasLookup) {
            String rationale = event.getBlacklistInfo().map(arg_0 -> ((FindingBlacklistEvent.EExtendedBlacklistChangeType)event.getExtendedType()).getRationale(arg_0)).orElse("");
            return new ExclusionEventDto(event.getBlacklistInfo().map(FindingBlacklistInfo::getType).orElse(null), ExclusionEventDto.getTimestamp(event, commit), event.getUser(), aliasLookup.resolveUser(event.getUser()).orElse(null), event.getExtendedType(), rationale, commit);
        }

        private static long getTimestamp(FindingBlacklistEvent event, CommitDescriptor resolvedCommit) {
            return switch (event.getExtendedType()) {
                default -> throw new MatchException(null, null);
                case FindingBlacklistEvent.EExtendedBlacklistChangeType.EXCLUSION, FindingBlacklistEvent.EExtendedBlacklistChangeType.PENDING_EXCLUSION -> event.getBlacklistInfo().map(FindingBlacklistInfo::getTimestamp).orElse(resolvedCommit.getTimestamp());
                case FindingBlacklistEvent.EExtendedBlacklistChangeType.APPROVAL, FindingBlacklistEvent.EExtendedBlacklistChangeType.REJECTION -> event.getBlacklistInfo().map(FindingBlacklistInfo::getApprovalState).map(FindingBlacklistInfo.IApprovalState.IResolvedState.class::cast).map(FindingBlacklistInfo.IApprovalState.IResolvedState::at).orElseThrow();
                case FindingBlacklistEvent.EExtendedBlacklistChangeType.REMOVAL -> resolvedCommit.getTimestamp();
            };
        }
    }
}

