/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.sonarlint;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisPull;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/analysis/sonarlint")
public class SonarLintAnalysisWebhooksService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @RequiresNoLogin
    @Operation(summary="Get SonarLint analysis results", description="Gets the SonarLint analysis results. Results may be incomplete if the session is not in the completed status.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="404", description="No session found with the given key.")})
    @Path(value="completion-hook")
    public void receiveAnalysisCompletedConfirmation(@QueryParam(value="sessionKey") String sessionKey, @QueryParam(value="projectId") IProjectId projectId, @QueryParam(value="commitDescriptor") UnresolvedCommitDescriptor commit) throws StorageException {
        LOGGER.debug("Received completion confirmation for session '{}'. Setting pull trigger to ready now.", (Object)sessionKey);
        IndexLayer indexLayer = this.getIndexLayer();
        ISchedulerCommunicator.getInstance().sendSetJobReadyCommand(indexLayer.getMessageBroker(), indexLayer.resolveToInternalProjectId(projectId), this.resolve(commit), SonarLintIndependentAnalysisPull.class.getSimpleName());
    }
}

