/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.model.TeamscaleIssueStatus;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/commit-issues")
public class CommitIssuesService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Retrieve commit issues", description="Returns the issues associated with the given commits.", tags={"Issues"})
    public List<@Nullable List<TeamscaleIssueStatus>> getIssuesByRepositoryCommits(@QueryParam(value="commit") List<UnresolvedCommitDescriptor> commits) throws StorageException {
        return CommitIssuesService.getIssuesForCommits((ProjectStorageSystem)this.getProjectStorageSystem(), this.resolveCommits(commits));
    }

    public static @NonNull List<List<TeamscaleIssueStatus>> getIssuesForCommits(ProjectStorageSystem projectStorageSystem, List<@NonNull CommitDescriptor> commitDescriptors) throws StorageException {
        RepositoryCommitIssueMappingIndex commitIssueMappingIndex = (RepositoryCommitIssueMappingIndex)projectStorageSystem.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null);
        IssueIndex issueIndex = (IssueIndex)projectStorageSystem.openProjectIndex(IssueIndex.class, null);
        List issueIds = commitIssueMappingIndex.getIssuesForCommits(commitDescriptors);
        Set<TeamscaleIssueId> allIssueIds = CommitIssuesService.extractAllIssueIds(issueIds);
        HashMap<TeamscaleIssueId, TeamscaleIssueStatus> issueLookup = new HashMap<TeamscaleIssueId, TeamscaleIssueStatus>();
        ArrayList<TeamscaleIssueId> allIssuesIdsList = new ArrayList<TeamscaleIssueId>(allIssueIds);
        List issues = issueIndex.getIssues(allIssuesIdsList);
        for (int i = 0; i < issues.size(); ++i) {
            TeamscaleIssue issue = (TeamscaleIssue)issues.get(i);
            if (issue == null) continue;
            issueLookup.put((TeamscaleIssueId)allIssuesIdsList.get(i), new TeamscaleIssueStatus(issue));
        }
        return CommitIssuesService.createResult(issueIds, issueLookup);
    }

    private static List<List<TeamscaleIssueStatus>> createResult(List<List<TeamscaleIssueId>> issueIds, Map<TeamscaleIssueId, TeamscaleIssueStatus> issueLookup) {
        ArrayList<List<TeamscaleIssueStatus>> result = new ArrayList<List<TeamscaleIssueStatus>>();
        for (List<TeamscaleIssueId> issueIdList : issueIds) {
            if (issueIdList != null) {
                List issues = issueIdList.stream().map(issueLookup::get).filter(Objects::nonNull).collect(Collectors.toList());
                result.add(issues);
                continue;
            }
            result.add(null);
        }
        return result;
    }

    private static Set<TeamscaleIssueId> extractAllIssueIds(List<List<TeamscaleIssueId>> issueIds) {
        HashSet<TeamscaleIssueId> allIssueIds = new HashSet<TeamscaleIssueId>();
        for (List<TeamscaleIssueId> issueIdList : issueIds) {
            if (issueIdList == null) continue;
            allIssueIds.addAll(issueIdList);
        }
        return allIssueIds;
    }
}

