/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.user.User;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.issues.IQueryFunction;
import com.teamscale.wia.TeamscaleIssue;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.AutocompletionResult;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.IndexAutocompleter;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.engine.persistence.index.keyed.query.parser.QueryParser;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.js_export.ExportAsType;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class QueryServiceBase
extends ApiBase {
    public static List<String> performQueryWithErrorHandling(String query, IKeyedObjectIndex<?> historyIndex, HistoryAccessOption historyAccessOption, StoredQueryIndex.EStoredQueryType queryType, ITeamscaleServiceInfo serviceInfo) throws StorageException {
        return QueryServiceBase.performQueryErrorHandling(query, () -> {
            CommitResolvingStorageSystem projectStorageSystem = serviceInfo.getProjectStorageSystem();
            return QueryableEntityUtils.performQueryWithEmptyHandling((String)query, (IKeyedObjectIndex)historyIndex, (QueryableEntityUtils.QueryContext)QueryableEntityUtils.QueryContext.ofTimestamp((ProjectStorageSystem)projectStorageSystem, (GlobalStorageSystem)serviceInfo.getGlobalStorageSystem(), (User)serviceInfo.getUser(), (StoredQueryIndex.EStoredQueryType)queryType, (HistoryAccessOption)historyAccessOption));
        });
    }

    public static <T> T performQueryErrorHandling(String query, IQueryFunction<T> queryFunction) throws StorageException {
        try {
            return queryFunction.performQuery();
        }
        catch (QueryParsingException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)QueryServiceBase.getFailureFromParsingException(e, query)).build());
        }
        catch (QueryCompilationException e) {
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)QueryServiceBase.getFailureFromCompilationException(e, query)).build());
        }
    }

    protected @NonNull List<TeamscaleIssue> performIssueQuery(String query, IKeyedObjectIndex<TeamscaleIssue> issueHistoryIndex, HistoryAccessOption historyAccess) throws StorageException {
        List<String> issueIds = QueryServiceBase.performQueryWithErrorHandling(query, issueHistoryIndex, historyAccess, StoredQueryIndex.EStoredQueryType.ISSUE, this.serviceInfo);
        return CollectionUtils.filter((Collection)issueHistoryIndex.getByIds(issueIds), Objects::nonNull);
    }

    protected final boolean validateQuery(String query, StoredQueryIndex.EStoredQueryType queryType) throws StorageException {
        try {
            QueryableEntityUtils.QueryContext queryContext = QueryableEntityUtils.QueryContext.ofTimestamp((ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (StoredQueryIndex.EStoredQueryType)queryType, (long)DateTimeUtils.millisNow(), (String)this.getDefaultBranchName()).onlyForQueryValidation();
            QueryParser.parse((String)query, (Collection)queryContext.getPreprocessors());
        }
        catch (QueryParsingException e) {
            return false;
        }
        return true;
    }

    protected final AutocompletionResult getAutocompletionSuggestions(IKeyedObjectIndex<?> historyIndex, String queryTerm, StoredQueryIndex.EStoredQueryType queryType) throws StorageException {
        return this.getAutocompletionSuggestions(historyIndex, queryTerm, queryType, Collections.emptyMap());
    }

    protected final AutocompletionResult getAutocompletionSuggestions(IKeyedObjectIndex<?> historyIndex, String queryTerm, StoredQueryIndex.EStoredQueryType queryType, Map<Pair<EQueryTokenType, Integer>, SupplierWithException<List<String>, ?>> additionalSuggestionsForFunctionKeyword) throws StorageException {
        HashMap<String, List<String>> suggestions = new HashMap<String, List<String>>();
        suggestions.put("assignee", Collections.singletonList("currentUser()"));
        suggestions.put("author", Collections.singletonList("currentUser()"));
        additionalSuggestionsForFunctionKeyword = new HashMap(additionalSuggestionsForFunctionKeyword);
        additionalSuggestionsForFunctionKeyword.putIfAbsent((Pair<EQueryTokenType, Integer>)new Pair((Object)EQueryTokenType.QUERY, (Object)0), () -> StoredQueryIndex.openIndex((ProjectStorageSystem)this.getProjectStorageSystem(), (StoredQueryIndex.EStoredQueryType)queryType).getAllQueryNames());
        return new IndexAutocompleter(historyIndex, suggestions, additionalSuggestionsForFunctionKeyword, 10).getSuggestions(queryTerm);
    }

    public static QueryParserFailure getFailureFromParsingException(QueryParsingException e, String queryString) {
        Integer startPosition = null;
        Integer endPosition = null;
        if (e.getToken().isPresent()) {
            startPosition = ((QueryToken)e.getToken().get()).getPosition();
            String text = ((QueryToken)e.getToken().get()).getText();
            endPosition = startPosition + text.length();
        }
        return new QueryParserFailure(e.getMessage(), startPosition, endPosition, queryString);
    }

    public static QueryParserFailure getFailureFromCompilationException(QueryCompilationException e, String queryString) {
        String text = e.getText();
        int startPosition = queryString.indexOf(text);
        Integer endPosition = startPosition + text.length();
        return new QueryParserFailure(e.getMessage(), startPosition, endPosition, queryString);
    }

    protected boolean isRequirementsManagementConnectorId(String connectorId) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)this.serviceInfo.getPrimaryPublicId(), (IndexLayer)this.getIndexLayer());
        if (projectConfiguration == null) {
            return false;
        }
        return projectConfiguration.getConnectors().stream().filter(connectorConfiguration -> connectorId.equals(connectorConfiguration.getIdentifier())).map(ConnectorConfiguration::getRequirementsManagementToolType).anyMatch(Optional::isPresent);
    }

    public record QueryParserFailure(@JsonProperty(value="message") String message, @JsonProperty(value="startPosition") @Nullable Integer startPosition, @JsonProperty(value="endPosition") @Nullable Integer endPosition, @JsonProperty(value="query") String query) {
    }

    @ExportToTypeScript
    public static class IssueQueryResult<T> {
        private static final String RESULT_SIZE_PROPERTY_NAME = "resultSize";
        private static final String ISSUES_PROPERTY_NAME = "issues";
        private static final String NEXT_START_INDEX_PROPERTY_NAME = "nextStartIndex";
        @JsonProperty(value="resultSize")
        private final int resultSize;
        @JsonProperty(value="issues")
        @JsonIgnoreProperties(value={"description"})
        private final @ExportAsType(value="UserResolvedTeamscaleIssue[] | ReferenceResolvedSpecItem[]") List<T> issues = new ArrayList<T>();
        @JsonProperty(value="nextStartIndex")
        private final int nextStartIndex;

        public static <T> IssueQueryResult<T> of(int resultSize, List<T> issues, int nextStartIndex) {
            return new IssueQueryResult<T>(resultSize, issues, nextStartIndex);
        }

        @JsonCreator
        private IssueQueryResult(@JsonProperty(value="resultSize") int resultSize, @JsonProperty(value="issues") List<T> issues, @JsonProperty(value="nextStartIndex") int nextStartIndex) {
            this.resultSize = resultSize;
            this.nextStartIndex = nextStartIndex;
            this.issues.addAll(issues);
        }

        public List<T> getIssues() {
            return this.issues;
        }
    }
}

