/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.interaction.ShortInteractionLog;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IProjectLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/logs/interaction")
public class InteractionLogProjectLogService
extends ApiBase
implements IProjectLogServiceApi<ShortInteractionLog, DetailedWorkerLog> {
    @Override
    @Operation(summary="Get all interaction logs", description="Returns a list of all interaction short logs.", tags={"Logging"}, operationId="getProjectInteractionLogs")
    public ShortLogResponse<ShortInteractionLog> getAllShortLogs(PublicProjectId project, @BeanParam LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, this.openInteractionLogIndex(project));
    }

    @Override
    @Operation(summary="Get interaction detail log", description="Returns the detailed interaction log entry for the given timestamp.", tags={"Logging"}, operationId="getProjectInteractionLog")
    public DetailedWorkerLog getDetailedLog(PublicProjectId project, LogEntryIdentifier logEntryIdentifier) throws StorageException {
        throw new BadRequestException("Loading detailed entries is not implemented for interaction logs.");
    }

    @Override
    @Operation(summary="Get interaction log frequencies", description="Returns the frequencies of the various interaction log types (i.e. INFO/WARN/ERROR).", tags={"Logging"}, operationId="getProjectInteractionLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies(PublicProjectId project) throws StorageException {
        return LogServiceUtils.obtainFrequencies(this.openInteractionLogIndex(project));
    }

    @Override
    @Operation(summary="Download interaction logs", description="Returns a file download of all interaction logs.", tags={"Logging"}, operationId="downloadProjectInteractionLogs")
    public Response downloadLog(PublicProjectId project, LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)"TeamscaleInteractionLogExport", (LogFilteringParameters)logFilteringParameters, (int)maxChars, this.openInteractionLogIndex(project));
    }

    @Override
    @Operation(summary="Delete interaction logs", description="Deletes all log entries in the specified project that match the applied filters.", tags={"Logging"}, operationId="deleteProjectInteractionLogs")
    public void deleteLogEntries(PublicProjectId project, LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, this.openInteractionLogIndex(project));
        AuditLogs.projectLogDeletion((String)"interaction logs", (PublicProjectId)project);
    }

    private LogIndexesWrapper<ShortInteractionLog, DetailedWorkerLog> openInteractionLogIndex(PublicProjectId project) throws StorageException {
        IndexLayer indexLayer = this.serviceInfo.getIndexLayer();
        PairList workerLogIndexes = PairList.from((Object)project, (Object)LogServiceUtils.determineIndexForProject((PublicProjectId)project, (IndexLayer)indexLayer, LogServiceUtils::getGlobalInteractionLogIndex, LogServiceUtils::getProjectInteractionLogIndex));
        return new LogIndexesWrapper(workerLogIndexes);
    }
}

