/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.service.DetailedServiceLog;
import com.teamscale.core.log.service.ShortServiceLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IProjectLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/logs/service")
public class ServiceLogProjectLogService
extends ApiBase
implements IProjectLogServiceApi<ShortServiceLog, DetailedServiceLog> {
    @Override
    @Operation(summary="Get all service logs", description="Returns a list of all service short logs.", tags={"Logging"}, operationId="getProjectServiceLogs")
    public ShortLogResponse<ShortServiceLog> getAllShortLogs(PublicProjectId project, LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, this.openServiceLogIndexes(project));
    }

    @Override
    @Operation(summary="Get service detail log", description="Returns the detailed service log entry for the given timestamp.", tags={"Logging"}, operationId="getProjectServiceLog")
    public DetailedServiceLog getDetailedLog(PublicProjectId project, LogEntryIdentifier logEntryIdentifier) throws StorageException {
        return (DetailedServiceLog)LogServiceUtils.getDetailedLogEntry(this.openServiceLogIndexes(project), (LogEntryIdentifier)logEntryIdentifier);
    }

    @Override
    @Operation(summary="Get service log frequencies", description="Returns the frequencies of the various service log types (i.e. INFO/WARN/ERROR).", tags={"Logging"}, operationId="getProjectServiceLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies(PublicProjectId project) throws StorageException {
        return LogServiceUtils.obtainFrequencies(this.openServiceLogIndexes(project));
    }

    @Override
    @Operation(summary="Download service logs", description="Returns a file download of all service logs.", tags={"Logging"}, operationId="downloadProjectServiceLogs")
    public Response downloadLog(PublicProjectId project, LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)"TeamscaleServiceLogExport", (LogFilteringParameters)logFilteringParameters, (int)maxChars, this.openServiceLogIndexes(project));
    }

    @Override
    @Operation(summary="Delete service logs", description="Deletes all log entries in the specified project that match the applied filters.", tags={"Logging"}, operationId="deleteProjectServiceLogs")
    public void deleteLogEntries(PublicProjectId project, LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, this.openServiceLogIndexes(project));
        AuditLogs.projectLogDeletion((String)"service logs", (PublicProjectId)project);
    }

    private LogIndexesWrapper<ShortServiceLog, DetailedServiceLog> openServiceLogIndexes(PublicProjectId project) throws StorageException {
        return new LogIndexesWrapper(PairList.from((Object)project, (Object)LogServiceUtils.determineIndexForProject((PublicProjectId)project, (IndexLayer)this.serviceInfo.getIndexLayer(), LogServiceUtils::getGlobalServiceLogIndex, LogServiceUtils::getProjectServiceLogIndex)));
    }
}

