/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.table;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/cross-project/metric-aggregation")
public class MultiProjectMetricAggregationService
extends ApiBase {
    private static final Set<String> BASE_ASSESSMENTS = CollectionUtils.asHashSet((Object[])new String[]{"File Size Assessment", "Nesting Depth Assessment", "Method Length Assessment"});
    private static final Set<String> BASE_DENSITY_METRICS = CollectionUtils.asHashSet((Object[])new String[]{"Clone Coverage", "Line Coverage", "Findings Density"});
    private static final Set<String> BASE_ABSOLUTE_METRICS = CollectionUtils.asHashSet((Object[])new String[]{"Lines of Code", "Source Lines of Code"});

    @Operation(summary="Get aggregated metrics", description="Returns, for the given uniform path, a map of metric name to metric value (Double or Assessment), depending on the type of metric.")
    @GET
    @RequiresNoPermission(description="Requires 'View Project' permission for all given projects")
    public Map<String, Object> getMetrics(@PathParam(value="uniformPath") @DefaultValue(value="") UniformPath uniformPath, @QueryParam(value="t") UnresolvedCommitDescriptor commit, @QueryParam(value="absolute-metric") @Parameter(description="A list of metric names that will be evaluated and returned. If not set, ALL metrics of the schema are used.") List<String> additionalAbsoluteMetrics, @QueryParam(value="density") @Parameter(description="A list of density metric names that will be evaluated and returned (e.g. Branch Coverage, or Finding Density Red).") List<String> additionalDensityMetrics, @QueryParam(value="assessment") @Parameter(description="A list of assessment metric names that will be evaluated and returned (e.g. Cyclomatic Complexity Assessment).") List<String> additionalAssessmentMetrics, @QueryParam(value="project") @Parameter(required=true, description="A list of metric names that will be evaluated and returned. If not set, ALL metrics of the schema are used.") List<PublicProjectId> projects) throws StorageException {
        HashSet<String> absoluteMetrics = new HashSet<String>(BASE_ABSOLUTE_METRICS);
        HashSet<String> densityMetrics = new HashSet<String>(BASE_DENSITY_METRICS);
        HashSet<String> assessments = new HashSet<String>(BASE_ASSESSMENTS);
        absoluteMetrics.addAll(additionalAbsoluteMetrics);
        densityMetrics.addAll(additionalDensityMetrics);
        assessments.addAll(additionalAssessmentMetrics);
        Map<PublicProjectId, Map<String, Object>> metricsByProject = this.getMetricsByProject(projects, uniformPath, this.determineHistoryOption(commit), absoluteMetrics, densityMetrics, assessments);
        HashMap<String, Object> aggregatedResultsByMetric = new HashMap<String, Object>();
        MultiProjectMetricAggregationService.aggregateAbsoluteMetrics(absoluteMetrics, metricsByProject, aggregatedResultsByMetric);
        MultiProjectMetricAggregationService.aggregateDensities(densityMetrics, metricsByProject, aggregatedResultsByMetric);
        MultiProjectMetricAggregationService.aggregateAssessments(assessments, metricsByProject, aggregatedResultsByMetric);
        return aggregatedResultsByMetric;
    }

    private static void aggregateAbsoluteMetrics(Set<String> absoluteMetrics, Map<PublicProjectId, Map<String, Object>> metricsByProject, Map<String, Object> aggregatedResultsByMetric) {
        for (String metric : absoluteMetrics) {
            double total = 0.0;
            for (Map.Entry<PublicProjectId, Map<String, Object>> entry : metricsByProject.entrySet()) {
                total += ((Double)entry.getValue().get(metric)).doubleValue();
            }
            aggregatedResultsByMetric.put(metric, total);
        }
    }

    private static void aggregateDensities(Set<String> densityMetrics, Map<PublicProjectId, Map<String, Object>> metricsByProject, Map<String, Object> aggregatedResultsByMetric) {
        for (String metric : densityMetrics) {
            double total = 0.0;
            for (Map.Entry<PublicProjectId, Map<String, Object>> entry : metricsByProject.entrySet()) {
                Map<String, Object> metrics = entry.getValue();
                total += (Double)metrics.get(metric) * ((Double)metrics.get("Source Lines of Code") / (Double)aggregatedResultsByMetric.get("Source Lines of Code"));
            }
            aggregatedResultsByMetric.put(metric, total);
        }
    }

    private static void aggregateAssessments(Set<String> assessments, Map<PublicProjectId, Map<String, Object>> metricsByProject, Map<String, Object> aggregatedResultsByMetric) {
        for (String metric : assessments) {
            ArrayList<Assessment> parts = new ArrayList<Assessment>();
            for (Map.Entry<PublicProjectId, Map<String, Object>> entry : metricsByProject.entrySet()) {
                parts.add((Assessment)entry.getValue().get(metric));
            }
            Assessment total = Assessment.aggregate(parts);
            aggregatedResultsByMetric.put(metric, total);
        }
    }

    private Map<PublicProjectId, Map<String, Object>> getMetricsByProject(List<PublicProjectId> projects, UniformPath uniformPath, HistoryAccessOption historyAccessOption, Set<String> absoluteMetrics, Set<String> densityMetrics, Set<String> assessments) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        HashMap<PublicProjectId, Map<String, Object>> valuesByProject = new HashMap<PublicProjectId, Map<String, Object>>();
        for (PublicProjectId publicProjectId : projects) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            InternalProjectId internalProjectId = projectIndex.resolveToInternalId((IProjectId)publicProjectId);
            this.getPermissions().checkProjectPermission((IProjectId)internalProjectId, EProjectPermission.VIEW);
            CommitResolvingStorageSystem projectStorageSystem = this.getProjectStorageSystem((IProjectId)internalProjectId);
            MetricSchemaIndex metricsSchemaIndex = (MetricSchemaIndex)projectStorageSystem.openProjectIndex(MetricSchemaIndex.class, "metric-schema", HistoryAccessOption.readHeadUnbranched());
            MetricDirectorySchema schema = metricsSchemaIndex.getPublicSchema();
            MetricDirectoryIndex metricsDirectoryIndex = (MetricDirectoryIndex)projectStorageSystem.openProjectIndex(MetricDirectoryIndex.class, "metrics-dir", historyAccessOption);
            MetricDirectoryEntry directoryEntry = metricsDirectoryIndex.getMetricDirectoryEntry(uniformPath.toString());
            for (String metricName : CollectionUtils.unionSet(absoluteMetrics, (Collection[])new Collection[]{densityMetrics, assessments})) {
                int offset = schema.getValuePosition(metricName);
                Object value = directoryEntry.getValue(offset);
                values.put(metricName, value);
            }
            valuesByProject.put(publicProjectId, values);
        }
        return valuesByProject;
    }
}

