/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.metrics.treemap.builder.NumericValueTreeMapBuilderBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public class ChangeTreeMapBuilder
extends NumericValueTreeMapBuilderBase<Integer, TreeMapNode> {
    private final Map<String, Integer> changeValues;
    private final HistoryAccessOption historyAccessOptionAtStartCommit;
    private final HistoryAccessOption historyAccessOptionAtEndCommit;
    private Set<String> deletedPaths;
    private Set<String> addedPaths;
    static final Color ADDED_COLOR = Color.decode(ETrafficLightColor.GREEN.getHexValue());
    static final Color EDITED_COLOR = Color.BLUE;
    public static final Color DELETED_COLOR = Color.decode(ETrafficLightColor.RED.getHexValue());

    public ChangeTreeMapBuilder(HistoryAccessOption historyAccessOptionAtStartCommit, IMetricRetrievalStrategy metricRetrievalStrategyForEndCommit, HistoryAccessOption historyAccessOptionAtEndCommit, int areaMetricIndex, Map<UniformPath, Integer> changeValues) {
        super(null, null, metricRetrievalStrategyForEndCommit, historyAccessOptionAtEndCommit, areaMetricIndex, EDITED_COLOR, EDITED_COLOR, false);
        this.changeValues = changeValues.entrySet().stream().collect(Collectors.toMap(entry -> ((UniformPath)entry.getKey()).toStringAsMigrationFrontier(), Map.Entry::getValue));
        this.historyAccessOptionAtStartCommit = historyAccessOptionAtStartCommit;
        this.historyAccessOptionAtEndCommit = historyAccessOptionAtEndCommit;
    }

    @Override
    protected Map<String, Integer> calculateValues(String pathPrefix) {
        return this.changeValues;
    }

    @Override
    protected List<MetricDirectoryEntry> getEntriesFor(UniformPath uniformPath) throws StorageException {
        Map<String, MetricDirectoryEntry> startEntries = this.getEntryMap(uniformPath, this.historyAccessOptionAtStartCommit);
        Map<String, MetricDirectoryEntry> endEntries = this.getEntryMap(uniformPath, this.historyAccessOptionAtEndCommit);
        HashMap<String, MetricDirectoryEntry> mergedEntries = new HashMap<String, MetricDirectoryEntry>(endEntries);
        startEntries.forEach((path, entry) -> mergedEntries.merge((String)path, (MetricDirectoryEntry)entry, (endEntry, startEntry) -> endEntry));
        this.deletedPaths = CollectionUtils.differenceSet(startEntries.keySet(), (Collection[])new Collection[]{endEntries.keySet()});
        this.addedPaths = CollectionUtils.differenceSet(endEntries.keySet(), (Collection[])new Collection[]{startEntries.keySet()});
        return this.createArtificialEntries(new ArrayList<MetricDirectoryEntry>(mergedEntries.values()));
    }

    private Map<String, MetricDirectoryEntry> getEntryMap(UniformPath pathPrefix, HistoryAccessOption historyAccessOption) throws StorageException {
        List<MetricDirectoryEntry> entries = this.getEntriesFor(pathPrefix, historyAccessOption);
        HashMap<String, MetricDirectoryEntry> result = new HashMap<String, MetricDirectoryEntry>();
        for (MetricDirectoryEntry entry : entries) {
            result.put(entry.getUniformPath(), entry);
        }
        return result;
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) throws StorageException {
        return new TreeMapNode(entry.getUniformPath(), entry.getDoubleValue(this.areaMetricIndex), this.formatMetricValue(entry.getValueOrDefault(this.builderParameters.colorMetricIndex, this.builderParameters.colorMetricDefault)), this.determineColor(entry));
    }

    @Override
    protected @Nullable Color determineColor(MetricDirectoryEntry entry) throws StorageException {
        if (this.deletedPaths.contains(entry.getUniformPath())) {
            return DELETED_COLOR;
        }
        if (this.addedPaths.contains(entry.getUniformPath())) {
            return ADDED_COLOR;
        }
        return super.determineColor(entry);
    }
}

