/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import io.prometheus.metrics.core.metrics.CounterWithCallback;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.concurrent.MoreExecutors;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class IndexCallbackMetricsProviderBase {
    protected final IndexLayer indexLayer;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IParallelTaskExecutor PARALLEL_TASK_EXECUTOR = IndexCallbackMetricsProviderBase.constructParallelTaskExecutor();

    private static IParallelTaskExecutor constructParallelTaskExecutor() {
        int corePoolSize = (Integer)TeamscaleSystemProperties.PROMETHEUS_PARALLELISM_CORE_POOL_SIZE.getValue();
        int maximumPoolSize = (Integer)TeamscaleSystemProperties.PROMETHEUS_PARALLELISM_MAXIMUM_POOL_SIZE.getValue();
        AtomicInteger threadIndex = new AtomicInteger(1);
        return IParallelTaskExecutor.forExecutorService((ExecutorService)TeamscaleLogAppender.wrap((ExecutorService)MoreExecutors.newCachedThreadPool((int)corePoolSize, (int)maximumPoolSize, (int)1, (TimeUnit)TimeUnit.MINUTES, r -> IndexCallbackMetricsProviderBase.createWorkerThread(r, threadIndex.getAndIncrement()))));
    }

    private static Thread createWorkerThread(@NonNull Runnable r, int index) {
        return new Thread(r, "Teamscale Service Worker " + index);
    }

    protected static IParallelTaskExecutor getParallelTaskExecutor() {
        return PARALLEL_TASK_EXECUTOR;
    }

    protected IndexCallbackMetricsProviderBase(IndexLayer indexLayer) {
        this.indexLayer = indexLayer;
    }

    protected static void collectMetricValueByTwoDimHashmap(CounterWithCallback.Callback cb, TwoDimHashMap<String, String, Double> values) {
        for (String firstKey : values.getFirstKeys()) {
            for (Map.Entry valueBySecondKey : values.getSecondMap((Object)firstKey).entrySet()) {
                cb.call(((Double)valueBySecondKey.getValue()).doubleValue(), new String[]{firstKey, (String)valueBySecondKey.getKey()});
            }
        }
    }

    protected static void wrapInStorageExceptionLogger(GaugeWithCallback.Callback callback, SupplierWithException<Double, StorageException> throwingAccessor) {
        try {
            callback.call(((Double)throwingAccessor.get()).doubleValue(), new String[0]);
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve metrics.", (Throwable)e);
        }
    }

    protected <INTERMEDIATE> void doForAllProjects(@ThreadSafe FunctionWithException<ProjectStorageSystem, @Nullable INTERMEDIATE, StorageException> metricsProducer, BiConsumer<PublicProjectId, INTERMEDIATE> metricsConsumer) {
        List allProjectInfos = null;
        try {
            ProjectIndex projectIndex = this.indexLayer.openProjectIndex();
            allProjectInfos = projectIndex.getAllProjectInfos();
        }
        catch (StorageException storageException) {
            LOGGER.error("Could not retrieve list of projects to collect project metrics.", (Throwable)storageException);
        }
        if (allProjectInfos == null) {
            return;
        }
        try {
            Map results = (Map)PARALLEL_TASK_EXECUTOR.computeInParallel((Collection)allProjectInfos, project -> {
                CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem(project);
                return Map.entry(project.getPrimaryPublicId(), Optional.ofNullable(metricsProducer.apply((Object)projectStorageSystem)));
            }, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            results.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).map(entry -> Map.entry((PublicProjectId)entry.getKey(), ((Optional)entry.getValue()).get())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach(metricsConsumer);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Error collecting Prometheus metrics.", (Throwable)e);
        }
    }

    protected <INTERMEDIATE> void doForAllConnectors(@ThreadSafe FunctionWithException<ProjectConnectorCallbackInfo, @Nullable INTERMEDIATE, StorageException> metricsProducer, BiConsumer<Pair<PublicProjectId, String>, INTERMEDIATE> metricsConsumer) {
        this.doForAllProjects(projectStorageSystem -> IndexCallbackMetricsProviderBase.produceMetricsForAllConnectorsOfProject(metricsProducer, projectStorageSystem), (projectId, resultPerConnector) -> {
            Map<String, Object> intermediateResults = resultPerConnector.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).map(entry -> Map.entry((String)entry.getKey(), ((Optional)entry.getValue()).get())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            IndexCallbackMetricsProviderBase.consumeMetricsForAllConnectorsOfProject(metricsConsumer, projectId, intermediateResults);
        });
    }

    private static <INTERMEDIATE> void consumeMetricsForAllConnectorsOfProject(BiConsumer<Pair<PublicProjectId, String>, INTERMEDIATE> metricsConsumer, PublicProjectId projectId, Map<String, INTERMEDIATE> resultPerConnector) {
        if (resultPerConnector == null) {
            return;
        }
        for (Map.Entry<String, INTERMEDIATE> resultAndConnectorIdentifier : resultPerConnector.entrySet()) {
            metricsConsumer.accept((Pair<PublicProjectId, String>)Pair.createPair((Object)projectId, (Object)resultAndConnectorIdentifier.getKey()), resultAndConnectorIdentifier.getValue());
        }
    }

    private static <INTERMEDIATE> Map<String, Optional<INTERMEDIATE>> produceMetricsForAllConnectorsOfProject(FunctionWithException<ProjectConnectorCallbackInfo, @Nullable INTERMEDIATE, StorageException> metricsProducer, ProjectStorageSystem projectStorageSystem) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem);
        if (projectConfiguration == null) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, Optional<INTERMEDIATE>> resultPerConnector = new ConcurrentHashMap<String, Optional<INTERMEDIATE>>();
        for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
            Object result = metricsProducer.apply((Object)new ProjectConnectorCallbackInfo(projectStorageSystem, connector));
            resultPerConnector.put(connector.getIdentifier(), Optional.ofNullable(result));
        }
        return resultPerConnector;
    }

    protected record ProjectConnectorCallbackInfo(ProjectStorageSystem projectStorageSystem, ConnectorConfiguration connector) {
    }
}

