/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.portfolio;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import com.teamscale.index.portfolio.EQualityGoal;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
@Option(id="portfolio.overview", name="Portfolio overview options for process conformance", type=EOptionType.PROJECT, category=EOptionCategory.PORTFOLIO, visibilityFeatureToggle=EFeatureToggle.PORTFOLIO_OVERVIEW)
public class PortfolioOptions
implements IOption {
    public static final String OPTION_ID = "portfolio.overview";
    public static final String OPTION_NAME = "Portfolio overview options for process conformance";
    public static final String PORTFOLIO_LABELS_PROPERTY = "portfolioLabels";
    public static final String QUALITY_GOAL_PROPERTY = "qualityGoal";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="portfolioLabels")
    @OptionFieldDescription(name="The portfolio labels of this project, multiple labels can be specified seperated by a comma.")
    public String portfolioLabels = "";
    @JsonProperty(value="qualityGoal")
    @OptionFieldDescription(name="The quality goal assigned for this project, to calculate the process conformance against. Has to be one of the following: [\"QG1\", \"QG2\", \"QG3\" or \"QG4\"].")
    public String qualityGoal = "";

    public List<String> getLabels() {
        return this.parsePortfolioLabels().stream().distinct().toList();
    }

    public EQualityGoal getQualityGoal() {
        if (this.qualityGoal.isEmpty()) {
            return EQualityGoal.NOT_SET;
        }
        return EQualityGoal.valueOf((String)this.qualityGoal.toUpperCase());
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        try {
            this.parsePortfolioLabels();
            if (!StringUtils.isEmpty((String)this.qualityGoal)) {
                EQualityGoal.valueOf((String)this.qualityGoal.toUpperCase());
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    private List<String> parsePortfolioLabels() throws IllegalArgumentException {
        return CollectionUtils.parseMultiValueStringToList((String)this.portfolioLabels, (boolean)true);
    }

    public static PortfolioOptions getOptionsData(IndexLayer indexLayer, ProjectInfo projectId) throws StorageException {
        ProjectOptionIndex optionIndex = (ProjectOptionIndex)indexLayer.openProjectIndex(projectId, ProjectOptionIndex.class, null);
        PortfolioOptions option = (PortfolioOptions)ProjectOptionRegistry.getInstance().getOption("<p>", OPTION_ID, null, PortfolioOptions.class, (OptionIndexBase)optionIndex);
        CCSMAssert.isNotNull((Object)option);
        return option;
    }

    public boolean includesOneOf(List<String> otherLabels) {
        return otherLabels.isEmpty() || !CollectionUtils.intersectionSet(this.getLabels(), (Collection[])new Collection[]{otherLabels}).isEmpty();
    }
}

