/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.portfolio;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;

public abstract class PortfolioQualityGoalBase {
    @JsonProperty
    protected ProjectInfo projectInfo;
    protected final transient ITeamscaleServiceInfo storageInfo;

    public PortfolioQualityGoalBase(ProjectInfo projectInfo, ITeamscaleServiceInfo storageInfo) {
        this.projectInfo = projectInfo;
        this.storageInfo = storageInfo;
    }

    public boolean canBeAssessed() throws StorageException {
        ProjectAnalysisProgressIndex projectAnalysisIndex = (ProjectAnalysisProgressIndex)this.getIndexLayer().openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, (IProjectId)this.projectInfo.getPrimaryPublicId());
        return projectAnalysisIndex.getAnalysisState().equals((Object)EAnalysisState.LIVE_ANALYSIS);
    }

    protected CommitResolvingStorageSystem getProjectStorageSystem() throws StorageException {
        return this.storageInfo.getProjectStorageSystem(this.projectInfo);
    }

    protected IndexLayer getIndexLayer() {
        return this.storageInfo.getIndexLayer();
    }
}

