/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import com.teamscale.index.configuration.tools.message.ExternalAnalysisToolMessageManager;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.project.ExternalFindingsSchemaServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/external-findings/descriptions")
public class ExternalFindingsDescriptorService
extends ExternalFindingsSchemaServiceBase<ExternalFindingsDescription> {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Operation(summary="Get external finding descriptions", description="Retrieves all external finding descriptions available in the system", tags={"Findings"})
    public List<ExternalFindingsDescription> getExternalFindingsDescriptions() throws StorageException {
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        return storageIndex.getDescriptions(EAnalysisTool.CUSTOM);
    }

    @DELETE
    @Path(value="{externalFindingDescriptionName}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Operation(summary="Remove external finding description", description="Removes the external finding description identified by the given name", responses={@ApiResponse(responseCode="404", description="External finding description with given name could not be found")}, tags={"Findings"})
    public void deleteExternalFindingDescription(@Parameter(description="Name of the finding description to remove") @PathParam(value="externalFindingDescriptionName") String descriptionName) throws StorageException {
        ExternalFindingsDescription description = (ExternalFindingsDescription)this.getElementWithExistsCheck(descriptionName);
        this.deleteElement(description);
    }

    @PUT
    @Path(value="{externalFindingDescriptionTypeId}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Operation(summary="Update external finding description", description="Update the external finding description identified by the given name.", responses={@ApiResponse(responseCode="404", description="External finding description with given name could not be found."), @ApiResponse(responseCode="400", description="No type ID for finding description provided."), @ApiResponse(responseCode="400", description="Inconsistent type IDs provided."), @ApiResponse(responseCode="400", description="The given analysis tool is not supported as an external tool for custom findings.")}, tags={"Findings"})
    public void updateExternalFindingDescription(@Parameter(description="ID of the finding description to update") @PathParam(value="externalFindingDescriptionTypeId") String descriptionTypeId, @RequestBody(required=true) ExternalFindingsDescription newDescription) throws StorageException {
        ExternalFindingsDescription oldDescription = (ExternalFindingsDescription)this.getElementWithExistsCheck(descriptionTypeId);
        this.updateElement(oldDescription, newDescription);
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        ExternalAnalysisToolMessageManager.initializeMessageManagerFor((EAnalysisTool)EAnalysisTool.CUSTOM, (List)storageIndex.getDescriptions(EAnalysisTool.CUSTOM));
    }

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_6_0_0)
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_FINDINGS_SCHEMA})
    @Operation(summary="Create external finding description", description="Create a new external finding description in the system.", responses={@ApiResponse(responseCode="400", description="The provided external finding description is invalid."), @ApiResponse(responseCode="400", description="The given analysis tool is not supported as an external tool for custom findings.")}, tags={"Findings"})
    public void createExternalFindingDescription(@RequestBody(required=true) ExternalFindingsDescription newDescription) throws StorageException {
        this.createElement(newDescription);
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        ExternalAnalysisToolMessageManager.initializeMessageManagerFor((EAnalysisTool)EAnalysisTool.CUSTOM, (List)storageIndex.getDescriptions(EAnalysisTool.CUSTOM));
    }

    @Override
    protected void deleteElement(ExternalFindingsDescription elementToDelete) throws StorageException {
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        storageIndex.deleteDescription(elementToDelete.getTypeId(), EAnalysisTool.CUSTOM);
    }

    @Override
    protected void updateElement(ExternalFindingsDescription oldElement, ExternalFindingsDescription newElement) throws StorageException {
        String typeId = newElement.getTypeId();
        if (typeId == null || StringUtils.isEmpty((String)typeId)) {
            throw new BadRequestException("No type ID for finding description provided.");
        }
        if (!oldElement.getTypeId().equals(newElement.getTypeId())) {
            throw new BadRequestException("Inconsistent type IDs provided.");
        }
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        try {
            storageIndex.storeDescriptions(Collections.singletonList(newElement), EAnalysisTool.CUSTOM);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Could not save external finding description.", (Throwable)e);
        }
    }

    @Override
    protected void createElement(ExternalFindingsDescription newElement) throws StorageException {
        Optional errorMessage = newElement.validateIdentifiers();
        if (errorMessage.isPresent()) {
            throw new BadRequestException("The provided external finding description is invalid: " + (String)errorMessage.get());
        }
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        try {
            storageIndex.storeDescriptions(Collections.singletonList(newElement), EAnalysisTool.CUSTOM);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Could not save description", (Throwable)e);
        }
    }

    @Override
    protected ExternalFindingsDescription getElementFromIndex(String findingsDescriptorTypeId) throws StorageException {
        ExternalFindingsGroupDescriptionIndex storageIndex = this.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        return storageIndex.getDescription(findingsDescriptorTypeId, EAnalysisTool.CUSTOM);
    }
}

