/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.fasterxml.jackson.annotation.JsonValue;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.base.BranchPointerHistoryIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Function;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/branch-pointer-history")
public class BranchPointerHistoryService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get full branch pointer history", description="Get the recorded branch pointer history for all repositories and branches", tags={"Debugging"})
    public ProjectBranchPointerHistoryDto getBranchPointerHistory() throws StorageException {
        Map indexes = this.getProjectStorageSystem().openProjectIndexes(BranchPointerHistoryIndex.class, null);
        HashMap<String, RepositoryBranchPointerHistoryDto> result = HashMap.newHashMap(indexes.size());
        for (Map.Entry entry : indexes.entrySet()) {
            result.put((String)entry.getKey(), RepositoryBranchPointerHistoryDto.of(((BranchPointerHistoryIndex)entry.getValue()).getBranchPointerHistory()));
        }
        return new ProjectBranchPointerHistoryDto(result);
    }

    @GET
    @Path(value="{repository}")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get full branch pointer history for a repository", description="Get the recorded branch pointer history for all branches in the provided repository", tags={"Debugging"})
    public RepositoryBranchPointerHistoryDto getBranchPointerHistory(@PathParam(value="repository") @Parameter(description="Id of the repository/connector") String repository) throws StorageException {
        BranchPointerHistoryIndex index = this.openProjectIndex(BranchPointerHistoryIndex.class, BranchPointerHistoryIndex.getIndexName((String)repository), null);
        return RepositoryBranchPointerHistoryDto.of(index.getBranchPointerHistory());
    }

    @GET
    @Path(value="{repository}/{branch}")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get full branch pointer history for a branch in a repository", description="Get the recorded branch pointer history for the provided branch in the provided repository", tags={"Debugging"})
    public BranchPointerHistoryDto getBranchPointerHistory(@PathParam(value="repository") @Parameter(description="Id of the repository/connector") String repository, @PathParam(value="branch") @Parameter(description="branch to receive the history for") String branch) throws StorageException {
        BranchPointerHistoryIndex index = this.openProjectIndex(BranchPointerHistoryIndex.class, BranchPointerHistoryIndex.getIndexName((String)repository), null);
        return new BranchPointerHistoryDto(index.getBranchPointerHistory(branch));
    }

    @PUT
    @Path(value="truncate")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Truncate the branch pointer history", description="Truncates the branch pointer history of all repositories/branches", tags={"Debugging"})
    public void truncateBranchPointerHistory(@QueryParam(value="timestamp") @Parameter(description="Truncation timestamp") Instant timestamp) throws StorageException {
        Map indexes = this.getProjectStorageSystem().openProjectIndexes(BranchPointerHistoryIndex.class, null);
        for (BranchPointerHistoryIndex branchPointerHistoryIndex : indexes.values()) {
            branchPointerHistoryIndex.truncateHistory(timestamp);
        }
    }

    @PUT
    @Path(value="{repository}/truncate")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Truncate the branch pointer history of a repository", description="Truncates the branch pointer history of all branches in the provided repository", tags={"Debugging"})
    public void truncateBranchPointerHistory(@PathParam(value="repository") @Parameter(description="Id of the repository/connector") String repository, @QueryParam(value="timestamp") @Parameter(description="Truncation timestamp") Instant timestamp) throws StorageException {
        BranchPointerHistoryIndex index = this.openProjectIndex(BranchPointerHistoryIndex.class, BranchPointerHistoryIndex.getIndexName((String)repository), null);
        index.truncateHistory(timestamp);
    }

    @PUT
    @Path(value="{repository}/{branch}/truncate")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Truncate the branch pointer history of a branch in a repository", description="Truncates the branch pointer history of the provided branch in the provided repository", tags={"Debugging"})
    public void truncateBranchPointerHistory(@PathParam(value="repository") @Parameter(description="Id of the repository/connector") String repository, @PathParam(value="branch") @Parameter(description="branch to truncate the history for") String branch, @QueryParam(value="timestamp") @Parameter(description="Truncation timestamp") Instant timestamp) throws StorageException {
        BranchPointerHistoryIndex index = this.openProjectIndex(BranchPointerHistoryIndex.class, BranchPointerHistoryIndex.getIndexName((String)repository), null);
        index.truncateBranchHistory(branch, timestamp);
    }

    @DELETE
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Clear the branch pointer history", description="Clears the recorded branch pointer history for all branches in all repositories", tags={"Debugging"})
    public void clearBranchPointerHistory() throws StorageException {
        Map indexes = this.getProjectStorageSystem().openProjectIndexes(BranchPointerHistoryIndex.class, null);
        for (BranchPointerHistoryIndex index : indexes.values()) {
            index.clear();
        }
    }

    @Path(value="{repository}")
    @DELETE
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Clear the branch pointer history of a repository", description="Clears the recorded branch pointer history for all branches in the provided repository", tags={"Debugging"})
    public void clearBranchPointerHistory(@PathParam(value="repository") @Parameter(description="Id of the repository/connector") String repository) throws StorageException {
        this.openProjectIndex(BranchPointerHistoryIndex.class, BranchPointerHistoryIndex.getIndexName((String)repository), null).clear();
    }

    @Path(value="{repository}/{branch}")
    @DELETE
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Clear the branch pointer history of a branch in a repository", description="Clears the recorded branch pointer history for the provided branch in the provided repository", tags={"Debugging"})
    public void clearBranchPointerHistory(@PathParam(value="repository") @Parameter(description="Id of the repository/connector") String repository, @PathParam(value="branch") @Parameter(description="branch to clear the history for") String branch) throws StorageException {
        this.openProjectIndex(BranchPointerHistoryIndex.class, BranchPointerHistoryIndex.getIndexName((String)repository), null).clearBranchHistory(branch);
    }

    public record RepositoryBranchPointerHistoryDto(@JsonValue Map<String, BranchPointerHistoryDto> history) {
        static RepositoryBranchPointerHistoryDto of(Map<String, NavigableMap<Instant, String>> history) {
            return new RepositoryBranchPointerHistoryDto(CollectionUtils.map(history, Function.identity(), BranchPointerHistoryDto::new));
        }
    }

    public record ProjectBranchPointerHistoryDto(@JsonValue Map<String, RepositoryBranchPointerHistoryDto> history) {
    }

    public record BranchPointerHistoryDto(@JsonValue NavigableMap<Instant, String> history) {
    }
}

