/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.repository.RequiredPartitionsChecker;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/external-analysis/security-overview/missing-partitions")
public class RequiredPartitionsForSecurityOverviewService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Check required partitions for security overview", description="Returns all required partitions without external uploads across all code connectors", tags={"External Analysis"})
    public List<RequiredPartitionsChecker.MissingPartitionInfo> getMissingPartitionsForSecurityView(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException, ProjectConfigurationException {
        ConfigurationInitializationContext initializationContext = new ConfigurationInitializationContext(this.getIndexLayer(), (IExternalCredentialsProvider)this.openGlobalIndex(ExternalCredentialsIndex.class));
        RequiredPartitionsChecker checker = new RequiredPartitionsChecker(initializationContext, (ProjectStorageSystem)this.serviceInfo.getProjectStorageSystem());
        CommitDescriptor resolvedCommit = this.resolve(commit);
        return checker.checkMissingPartitionUploads(resolvedCommit);
    }
}

