/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository.github.debug;

import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/github/debug/app-installations/list")
public class GitHubInstallationsService
extends ApiBase {
    @GET
    @Operation(summary="Returns GitHub installations.", description="Lists all known organizations/users with installations of the GitHub app.", tags={"Voting Connectors", "Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String listGitHubInstallations() throws StorageException {
        GitHubInstallationIndex installationIndex = this.openGlobalIndex(GitHubInstallationIndex.class);
        StringBuilder builder = new StringBuilder();
        for (String organizationOrUser : installationIndex.listInstalledOrganizationsOrUsers()) {
            builder.append(organizationOrUser).append("\n");
        }
        return builder.toString();
    }
}

