/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.preprocessing;

import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.service.testimpact.TestDataRetriever;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.preprocessing.TestPrioritizationPreprocessingStepBase;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class LoadTestDurationStep
extends TestPrioritizationPreprocessingStepBase {
    public LoadTestDurationStep(TestDataRetriever dataRetriever) {
        super(dataRetriever);
    }

    @Override
    public void execute(Set<PrioritizableTest> testSet) throws StorageException {
        Map<UniformPath.EType, List<PrioritizableTest>> testsByPartition = testSet.stream().collect(Collectors.groupingBy(PrioritizableTest::getUniformPathType));
        for (UniformPath.EType type : testsByPartition.keySet()) {
            List<PrioritizableTest> testsOfType = testsByPartition.get(type);
            List testPartitionAndPaths = CollectionUtils.map(testsOfType, LoadTestDurationStep::toPartitionAndPath);
            if (type == UniformPath.EType.TEST_EXECUTION) {
                this.loadTestExecutionDurations(testsOfType, testPartitionAndPaths);
                continue;
            }
            this.loadExecutionUnitDurations(testsOfType, testPartitionAndPaths);
        }
    }

    private void loadTestExecutionDurations(List<PrioritizableTest> testExecutions, List<PartitionAndPath> partitionAndPaths) throws StorageException {
        List<TestExecutionWithPartition> testExecutionValues = this.dataRetriever.getTestExecutions(partitionAndPaths);
        CollectionUtils.forEach(testExecutions, testExecutionValues, (test, testExecutionWithPartition) -> {
            if (testExecutionWithPartition != null) {
                test.setDurationInMs(Long.valueOf((long)testExecutionWithPartition.getTestExecution().getDurationMillis()));
            }
        });
    }

    private void loadExecutionUnitDurations(List<PrioritizableTest> executionUnits, List<PartitionAndPath> partitionAndPaths) throws StorageException {
        List<ExecutionUnit> testExecutionValues = this.dataRetriever.getExecutionUnits(partitionAndPaths);
        CollectionUtils.forEach(executionUnits, testExecutionValues, (testDetails, testExecutionWithPartition) -> {
            if (testExecutionWithPartition != null && testExecutionWithPartition.getDuration() != null) {
                testDetails.setDurationInMs(Long.valueOf(testExecutionWithPartition.getDuration().toMillis()));
            }
        });
    }

    private static PartitionAndPath toPartitionAndPath(PrioritizableTest test) {
        return new PartitionAndPath(test.getPartition(), test.getUniformPath());
    }
}

