/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testimpact.ExecutionUnitIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/execution-units/{executionUnit}")
public class ExecutionUnitsService
extends ApiBase {
    @GET
    @Path(value="partitions/{partition}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get execution unit", description="Returns a execution unit.", tags={"Tests"})
    public ExecutionUnit getExecutionUnit(@PathParam(value="executionUnit") @Parameter(description="The execution unit to return.") UniformPath executableUnitPath, @PathParam(value="partition") @Parameter(description="The partition of the execution unit") String partition, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        ExecutionUnitIndex testImplementationIndex = this.openProjectIndex(ExecutionUnitIndex.class, this.determineHistoryOption(commit));
        ExecutionUnit executionUnit = testImplementationIndex.getExecutionUnit(partition, executableUnitPath);
        if (executionUnit == null) {
            throw new NotFoundException("Execution unit " + String.valueOf(executableUnitPath) + " does not exist!");
        }
        return executionUnit;
    }
}

