/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.testimpact.TestLinksIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/tests/debug/dump-test-link-index")
public class DebugDumpTestLinkIndexService
extends ApiBase {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @GET
    @Operation(tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String dumpTestLinkIndex(@QueryParam(value="t") @Parameter(required=true) UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        StringBuilder outputBuilder = new StringBuilder();
        TestLinksIndex testLinksIndex = this.openProjectIndex(TestLinksIndex.class, historyAccessOption);
        List testLinkKeys = testLinksIndex.getAllUniformPaths();
        @Nullable List testLinkValues = testLinksIndex.getTestLinks(testLinkKeys);
        for (int i = 0; i < testLinkKeys.size(); ++i) {
            outputBuilder.append((String)testLinkKeys.get(i)).append(" => ").append(testLinkValues.get(i)).append("\n");
        }
        return outputBuilder.toString();
    }
}

