/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.IntSummaryStatistics;
import java.util.Objects;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class IntSummaryStatisticsHolder
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private IntSummaryStatistics statistics;

    public IntSummaryStatisticsHolder() {
        this(new IntSummaryStatistics());
    }

    public IntSummaryStatisticsHolder(IntSummaryStatistics statistics) {
        this.statistics = Objects.requireNonNull(statistics, "statistics");
    }

    public IntSummaryStatistics getStatistics() {
        return this.statistics;
    }

    public void update(int value) {
        this.statistics.accept(value);
    }

    public void merge(IntSummaryStatisticsHolder other) {
        this.merge(other.statistics);
    }

    private void merge(IntSummaryStatistics other) {
        this.statistics.combine(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        long count = this.statistics.getCount();
        out.writeLong(count);
        if (count > 0L) {
            out.writeInt(this.statistics.getMin());
            out.writeInt(this.statistics.getMax());
            out.writeLong(this.statistics.getSum());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        long count = in.readLong();
        if (count == 0L) {
            this.statistics = new IntSummaryStatistics();
        } else {
            int min = in.readInt();
            int max = in.readInt();
            long sum = in.readLong();
            this.statistics = new IntSummaryStatistics(count, min, max, sum);
        }
    }

    public String toString() {
        return this.statistics.toString();
    }
}

