/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Objects;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class IndexFinding
extends DetachedFinding {
    private static final long serialVersionUID = 1L;
    public static final Comparator<IndexFinding> STABLE_INDEX_FINDING_COMPARATOR = Comparator.comparing(f -> f.getLocation().getUniformPath()).thenComparing(f -> f.getLocation().getLocationKey()).thenComparing(IndexFinding::getTypeId).thenComparing(DetachedFinding::getMessage).thenComparing(DetachedFinding::getAssessment, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(f -> f.getCodeScopeName() == null ? null : f.getCodeScopeName().name(), Comparator.nullsFirst(Comparator.naturalOrder()));
    public static final long NO_TIMESTAMP = -1L;
    public static final String TYPE_ID_SEPARATOR = "/";
    protected static final String CODE_SCOPE_NAME_PROPERTY = "codeScopeName";
    @JsonProperty(value="analysisTimestamp")
    private long analysisTimestamp = -1L;
    @JsonProperty(value="typeId")
    private final String typeId;
    @JsonProperty(value="codeScopeName")
    protected @Nullable CodeScopeName codeScopeName;

    public IndexFinding(IndexFinding other) {
        super(other);
        this.analysisTimestamp = other.analysisTimestamp;
        this.typeId = other.typeId;
        this.codeScopeName = other.codeScopeName;
    }

    public IndexFinding(DetachedFinding finding, long analysisTimestamp) {
        super(finding);
        this.analysisTimestamp = analysisTimestamp;
        this.typeId = this.determineTypeId();
    }

    public IndexFinding(DetachedFinding finding, long analysisTimestamp, String typeId) {
        super(finding);
        this.analysisTimestamp = analysisTimestamp;
        this.typeId = typeId;
    }

    public static IndexFinding asRealtimeFinding(DetachedFinding finding) {
        return new IndexFinding(finding, -1L);
    }

    @JsonCreator
    public IndexFinding(@JsonProperty(value="groupName") String groupName, @JsonProperty(value="categoryName") String categoryName, @JsonProperty(value="message") String message, @JsonProperty(value="location") ElementLocation location) {
        super(groupName, categoryName, message, location);
        this.typeId = this.determineTypeId();
    }

    public void setCodeScopeName(CodeScopeName codeScopeName) {
        this.codeScopeName = Objects.requireNonNull(codeScopeName, CODE_SCOPE_NAME_PROPERTY);
    }

    private String determineTypeId() {
        return IndexFinding.makeFindingTypeId(this.getCategoryName(), this.getGroupName());
    }

    public static String makeFindingTypeId(String category, String group) {
        return category + TYPE_ID_SEPARATOR + group;
    }

    public long getAnalysisTimestamp() {
        return this.analysisTimestamp;
    }

    public void setAnalysisTimestamp(long timestamp) {
        this.analysisTimestamp = timestamp;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public @Nullable CodeScopeName getCodeScopeName() {
        return this.codeScopeName;
    }

    public boolean isRealTime() {
        return this.analysisTimestamp == -1L;
    }
}

