/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.ai.findings;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.AiEngineProviderOptionBase;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.ai.IAiObservabilityMonitor;
import com.teamscale.index.ai.ILlmEngine;
import com.teamscale.index.ai.findings.AiFindingResolutionEngine;
import com.teamscale.index.ai.findings.EAiFindingResolutionPromptGenerator;
import com.teamscale.index.ai.findings.FindingResolutionException;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.concurrent.ThreadUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.jspecify.annotations.NonNull;

public class AiFindingResolutionBenchmark {
    public static void main(String[] args) throws IOException, JsonSerializationException, StorageException, ServiceCallException {
        if (args.length != 3) {
            System.err.println("Call with three parameters: <data file> <config file> <prompt generator>");
            System.exit(1);
        }
        Path dataFile = Path.of(args[0], new String[0]);
        BenchmarkInputFile input = (BenchmarkInputFile)JsonUtils.deserializeFromJson((String)FileSystemUtils.readFileUTF8((Path)dataFile), BenchmarkInputFile.class);
        Path configFile = Path.of(args[1], new String[0]);
        BenchmarkConfig config = (BenchmarkConfig)JsonUtils.deserializeFromJson((String)FileSystemUtils.readFileUTF8((Path)configFile), BenchmarkConfig.class);
        String promptGenerator = args[2];
        EAiFindingResolutionPromptGenerator generator = (EAiFindingResolutionPromptGenerator)EnumUtils.valueOfIgnoreCase(EAiFindingResolutionPromptGenerator.class, (String)promptGenerator);
        if (generator == null) {
            System.err.println("Invalid prompt generator: " + promptGenerator);
            System.exit(1);
        }
        String optionName = "ai-engine." + config.llmName;
        ServerOptionRegistry.getInstance().loadServerOptionsFromFileContent(JsonUtils.serializeToJSON(Map.of(optionName + "/benchmark", AiFindingResolutionBenchmark.resolve1PasswordRefs(config.llmParameters))));
        AiEngineProviderOptionBase option = (AiEngineProviderOptionBase)ServerOptionRegistry.getInstance().getServerMultiOption(optionName, "benchmark", AiEngineProviderOptionBase.class, null);
        String validationResult = option.validate(null, null);
        if (validationResult != null) {
            System.err.println("Validation of config failed: " + validationResult);
            System.exit(1);
        }
        ILlmEngine llmEngine = (prompt, monitor) -> ((ILlmCompleter)option.createCompleter(monitor::reportMetric).orElseThrow()).complete(prompt);
        BenchmarkOutputFile output = AiFindingResolutionBenchmark.executeAiFindingResolutionBenchmark(input, llmEngine, generator, config.maxRequestsPerMinute);
        Path basePath = dataFile.getParent().getParent().getParent();
        Path targetFile = basePath.resolve("results").resolve(dataFile.getName(dataFile.getNameCount() - 2)).resolve(generator.name().toLowerCase()).resolve(configFile.getFileName());
        FileSystemUtils.writeFileUTF8((Path)targetFile, (String)JsonUtils.serializeToJSONPrettyPrint((Object)output));
        System.out.println("done");
    }

    private static Map<String, String> resolve1PasswordRefs(Map<String, String> llmParameters) {
        return llmParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> AiFindingResolutionBenchmark.resolve1PasswordRef((String)entry.getValue())));
    }

    private static String resolve1PasswordRef(String value) throws RuntimeException {
        if (!value.startsWith("op://")) {
            return value;
        }
        try {
            ProcessUtils.ExecutionResult result = ProcessUtils.execute((String[])new String[]{"op", "read", value});
            if (result.getReturnCode() != 0) {
                throw new RuntimeException("Failed to use 1password to resolve '" + value + "': " + result.getStderr());
            }
            return result.getStdout().trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static @NonNull BenchmarkOutputFile executeAiFindingResolutionBenchmark(BenchmarkInputFile input, ILlmEngine llmEngine, EAiFindingResolutionPromptGenerator promptGenerator, int maxRequestsPerMinute) {
        int count = 0;
        BenchmarkOutputFile output = new BenchmarkOutputFile(input.version, new ArrayList<BenchmarkResult>());
        long delayNanos = 0L;
        if (maxRequestsPerMinute > 0) {
            delayNanos = Duration.ofMinutes(1L).toNanos() / (long)maxRequestsPerMinute;
        }
        for (BenchmarkSample sample : input.samples()) {
            String resolution;
            long startNanos = System.nanoTime();
            CollectingMonitor monitor = new CollectingMonitor();
            AiFindingResolutionEngine engine = new AiFindingResolutionEngine(llmEngine, promptGenerator, monitor);
            TrackedFinding finding = new TrackedFinding("unused", "unused", sample.findingMessage, (ElementLocation)sample.findingLocation, "unused-id", null, null, CodeScopeAware.DEFAULT_CODE_SCOPE);
            ELanguage language = (ELanguage)EnumUtils.valueOfIgnoreCase(ELanguage.class, (String)sample.language);
            TokenElementInfo element = TokenElementInfo.createWithLocalPreprocessing(sample.findingLocation.getUniformPath(), language, sample.fileContent);
            FindingTypeDescription findingDescription = new FindingTypeDescription("not-used", sample.findingDescription, EAnalysisTool.TEAMSCALE);
            try {
                resolution = engine.suggestResolution(finding, element, findingDescription);
            }
            catch (FindingResolutionException e) {
                resolution = e.getMessage();
            }
            BenchmarkResult result = new BenchmarkResult(sample.id, resolution, monitor.metrics, monitor.steps);
            output.results.add(result);
            System.out.println("Completed " + ++count + " of " + input.samples().size() + " samples");
            long requiredDelay = delayNanos - (System.nanoTime() - startNanos);
            if (requiredDelay <= 0L) continue;
            ThreadUtils.sleep((long)(Duration.ofNanos(requiredDelay).toMillis() + 1L));
        }
        return output;
    }

    private record BenchmarkInputFile(String version, List<BenchmarkSample> samples) {
    }

    private record BenchmarkConfig(String llmName, Map<String, String> llmParameters, Map<String, String> llmEnvParameters, int maxRequestsPerMinute) {
    }

    private record BenchmarkOutputFile(String version, List<BenchmarkResult> results) {
    }

    private record BenchmarkSample(String id, String findingMessage, String findingDescription, TextRegionLocation findingLocation, String fileContent, String language) {
    }

    private static class CollectingMonitor
    implements IAiObservabilityMonitor {
        private final Map<String, String> steps = new HashMap<String, String>();
        private final Map<String, Double> metrics = new HashMap<String, Double>();

        private CollectingMonitor() {
        }

        @Override
        public void reportIntermediateStep(String name, String content) {
            this.steps.put(name, content);
        }

        @Override
        public void reportMetric(String name, double value) {
            this.metrics.put(name, value);
        }
    }

    private record BenchmarkResult(String id, String output, Map<String, Double> metrics, Map<String, String> steps) {
    }
}

