/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.index.code_clones.constraint.ICloneClassConstraint;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.core.Unit;
import com.teamscale.index.code_clones.normalization.FastUnifiedNormalization;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.TokenElementPreprocessingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class UnitAwareCloneClassFilter {
    private static final Set<String> CS_EMPTY_GETTER_AND_SETTER = Set.of("empty get", "empty set", "empty init");
    private final Map<String, List<Unit>> unitsByUniformPath = new HashMap<String, List<Unit>>();
    private final int minLength;
    private final List<ICloneClassConstraint> constraints;

    public UnitAwareCloneClassFilter(int minLength, List<ICloneClassConstraint> constraints) {
        this.minLength = minLength;
        this.constraints = constraints;
    }

    public List<CloneClass> filterCloneClasses(Collection<CloneClass> cloneClasses, Map<String, TokenElementInfo> uniformPathToElement) {
        this.loadUnits(uniformPathToElement);
        HashSet<String> cloneClassDescriptors = new HashSet<String>();
        ArrayList<CloneClass> result = new ArrayList<CloneClass>();
        for (CloneClass cloneClass : cloneClasses) {
            if (cloneClass.getClones().size() < 2 || cloneClass.getNormalizedLength() < this.minLength || !cloneClassDescriptors.add(UnitAwareCloneClassFilter.createCloneClassDescriptor(cloneClass))) continue;
            for (Clone clone : cloneClass.getClones()) {
                this.appendUnits(clone);
            }
            if (!this.constraints.stream().allMatch(constraint -> constraint.satisfied(cloneClass)) || UnitAwareCloneClassFilter.isCsInterfaceImplementation(cloneClass, uniformPathToElement)) continue;
            result.add(cloneClass);
        }
        return result;
    }

    private static boolean isCsInterfaceImplementation(CloneClass cloneClass, Map<String, TokenElementInfo> uniformPathToElement) {
        if (ELanguage.fromPath((String)Objects.requireNonNull((Clone)CollectionUtils.getAny(cloneClass.getClones())).getUniformPath()) != ELanguage.CS) {
            return false;
        }
        boolean foundInterface = false;
        for (Clone clone : cloneClass.getClones()) {
            TextRegionLocation location = clone.getLocation();
            TokenElementInfo element = uniformPathToElement.get(clone.getUniformPath());
            List<ShallowEntity> entities = UnitAwareCloneClassFilter.getEntitiesInLocation(TokenElementPreprocessingUtils.getUnpreprocessedEntitiesIfPossible(element), location);
            for (ShallowEntity entity : entities) {
                if (!UnitAwareCloneClassFilter.isCsProperty(entity) && !UnitAwareCloneClassFilter.isCsEmptyGetterOrSetter(entity)) {
                    return false;
                }
                if (entity.getParent().getType() != EShallowEntityType.TYPE || !entity.getParent().getSubtype().equals("interface")) continue;
                foundInterface = true;
            }
        }
        return foundInterface;
    }

    private static boolean isCsProperty(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.ATTRIBUTE && entity.getSubtype().equals("property");
    }

    private static boolean isCsEmptyGetterOrSetter(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD && CS_EMPTY_GETTER_AND_SETTER.contains(entity.getSubtype());
    }

    private static List<ShallowEntity> getEntitiesInLocation(List<ShallowEntity> entities, TextRegionLocation location) {
        ArrayList<ShallowEntity> result = new ArrayList<ShallowEntity>();
        for (ShallowEntity entity : ShallowEntityTraversalUtils.getAllEntities(entities)) {
            if (entity.getStartLine() >= location.getRawStartLine() && entity.getEndLine() <= location.getRawEndLine()) {
                result.add(entity);
            }
            if (!entity.isEmpty() || entity.getStartLine() <= location.getRawEndLine()) continue;
            break;
        }
        return result;
    }

    private static String createCloneClassDescriptor(CloneClass cloneClass) {
        ArrayList<CallSite> clonePositions = new ArrayList<CallSite>();
        for (Clone clone : cloneClass.getClones()) {
            TextRegionLocation location = clone.getLocation();
            String locationId = location.getUniformPath() + ":" + location.getRawStartOffset() + ":" + location.getRawEndOffset();
            if (clone.getComponent() != null) {
                locationId = clone.getComponent() + ":" + locationId;
            }
            clonePositions.add((CallSite)((Object)locationId));
        }
        Collections.sort(clonePositions);
        return StringUtils.concat(clonePositions, (String)";");
    }

    private void loadUnits(Map<String, TokenElementInfo> uniformPathToElement) {
        uniformPathToElement.forEach((uniformPath, element) -> this.unitsByUniformPath.put((String)uniformPath, FastUnifiedNormalization.getNormalizedUnits(element)));
    }

    private void appendUnits(Clone clone) {
        int endUnitIndex;
        int end;
        List<Unit> units = this.unitsByUniformPath.get(clone.getUniformPath());
        CCSMAssert.isNotNull(units);
        int startUnitIndex = clone.getStartUnitIndexInElement();
        int start = Collections.binarySearch(units, new SearchUnit(startUnitIndex), UnitByIndexComparator.INSTANCE);
        if (start < 0) {
            start = -start - 1;
        }
        end = (end = Collections.binarySearch(units, new SearchUnit(endUnitIndex = startUnitIndex + clone.getLengthInUnits() - 1), UnitByIndexComparator.INSTANCE)) < 0 ? -end - 1 : ++end;
        clone.setUnits(units.subList(start, end));
    }

    private static final class SearchUnit
    extends Unit {
        private SearchUnit(int index) {
            super(0, 0, "", "", index);
        }
    }

    private static final class UnitByIndexComparator
    implements Comparator<Unit> {
        private static final UnitByIndexComparator INSTANCE = new UnitByIndexComparator();

        private UnitByIndexComparator() {
        }

        @Override
        public int compare(Unit u1, Unit u2) {
            return u1.getIndexInElement() - u2.getIndexInElement();
        }
    }
}

