/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import java.io.IOException;
import java.util.function.Predicate;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.system.SystemUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class AnalysisToolsConfigurationUtils {
    public static ProcessUtils.ExecutionResult checkProgramAvailability(String executableName, Predicate<ProcessUtils.ExecutionResult> availabilityPredicate, boolean preventJemalloc) throws ProjectConfigurationException {
        String toolPath = executableName;
        try {
            ProcessUtils.ExecutionResult result;
            String[] pathAndArgument = new String[]{toolPath, "--version"};
            ProcessBuilder builder = new ProcessBuilder(pathAndArgument);
            if (preventJemalloc) {
                AnalysisToolsConfigurationUtils.preventUsageOfJemalloc(builder);
            }
            if (!availabilityPredicate.test(result = ProcessUtils.execute((ProcessBuilder)builder))) {
                throw new ProjectConfigurationException("Could not execute %s (using path %s)\n%s".formatted(executableName, toolPath, result.toLimitedString(500)));
            }
            return result;
        }
        catch (IOException e) {
            throw new ProjectConfigurationException("Could not execute %s (using path %s): %s".formatted(executableName, toolPath, e.getMessage()), (Throwable)e);
        }
    }

    public static void preventUsageOfJemalloc(ProcessBuilder builder) {
        if (!SystemUtils.isLinux()) {
            return;
        }
        String ldPreload = System.getenv("LD_PRELOAD");
        if (ldPreload != null && ldPreload.contains("jemalloc")) {
            builder.environment().put("LD_PRELOAD", "");
        }
    }

    private AnalysisToolsConfigurationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

