/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.index.external.metrics.ExternalMetricsSynchronizer;
import com.teamscale.index.project.ExternalCodeMetricsDescriptionIndex;
import com.teamscale.index.project.ExternalMetricsDescriptionIndexBase;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import eu.cqse.check.framework.scanner.ELanguage;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class CustomExternalMetricsConfiguration
extends ToolConfigurationBase {
    public static final String CUSTOM_EXTERNAL_METRICS_CATEGORY = "Custom External Metrics";
    public static final String CUSTOM_METRICS_FOLDER = "custom-external-metrics";
    public static final String CUSTOM_CODE_METRICS_FILE = "custom-external-metrics/metric-entries.json";
    public static final String CUSTOM_NON_CODE_METRICS_FILE = "custom-external-metrics/non-code-metric-entries.json";
    public static final String CUSTOM_METRICS_QUALITY_INDICATOR = "Custom Metrics";
    private final List<MetricSchemaChangeEntry> entries;
    private final ExternalCodeMetricsDescriptionIndex metricsDescriptionIndex;

    public CustomExternalMetricsConfiguration(GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        super(EAnalysisTool.CUSTOM_METRICS, CUSTOM_EXTERNAL_METRICS_CATEGORY);
        try {
            this.metricsDescriptionIndex = (ExternalCodeMetricsDescriptionIndex)globalStorageSystem.openGlobalIndex(ExternalCodeMetricsDescriptionIndex.class);
            this.entries = this.metricsDescriptionIndex.getAllMetrics();
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }

    public static void validateCustomExternalMetrics(List<MetricSchemaChangeEntry> metricEntries, ExternalMetricsDescriptionIndexBase externalMetricsDescriptionIndex) throws StorageException, BadRequestException {
        HashSet<String> errorMessages = new HashSet<String>();
        errorMessages.addAll(CustomExternalMetricsConfiguration.validateUniqueMetricIds(metricEntries));
        errorMessages.addAll(CustomExternalMetricsConfiguration.validateUniqueMetricDefinitionNamesInGroups(metricEntries, externalMetricsDescriptionIndex));
        if (!errorMessages.isEmpty()) {
            throw new BadRequestException("Invalid external metric description. " + String.join((CharSequence)"\n", errorMessages));
        }
    }

    private static Set<String> validateUniqueMetricDefinitionNamesInGroups(List<MetricSchemaChangeEntry> metricEntries, ExternalMetricsDescriptionIndexBase externalMetricsDescriptionIndex) throws StorageException {
        HashSet<String> errorMessages = new HashSet<String>();
        List<MetricSchemaChangeEntry> customExternalMetrics = externalMetricsDescriptionIndex.getAllMetrics();
        HashMap<String, Set<String>> metricDefinitionNames = new HashMap<String, Set<String>>();
        HashMap metricGroupAndNameToId = new HashMap();
        customExternalMetrics.forEach(metric -> {
            Set<String> namesInAnalysisGroup = CustomExternalMetricsConfiguration.getNamesInMetricAnalysisGroup(metric, metricDefinitionNames);
            namesInAnalysisGroup.add(metric.getMetricDirectoryEntry().getName());
            String groupAndName = CustomExternalMetricsConfiguration.convertAnalysisGroupAndNameToKey(metric);
            metricGroupAndNameToId.put(groupAndName, metric.getMetricId());
        });
        for (MetricSchemaChangeEntry metricEntry : metricEntries) {
            Set<String> namesInAnalysisGroup = CustomExternalMetricsConfiguration.getNamesInMetricAnalysisGroup(metricEntry, metricDefinitionNames);
            String metricDirectoryEntryName = metricEntry.getMetricDirectoryEntry().getName();
            String groupAndName = CustomExternalMetricsConfiguration.convertAnalysisGroupAndNameToKey(metricEntry);
            if (namesInAnalysisGroup.contains(metricDirectoryEntryName) && !metricEntry.getMetricId().equals(metricGroupAndNameToId.get(groupAndName))) {
                errorMessages.add("Metric name \"" + metricDirectoryEntryName + "\" is not unique in analysis group \"" + metricEntry.getAnalysisGroup() + "\".");
                continue;
            }
            namesInAnalysisGroup.add(metricDirectoryEntryName);
        }
        return errorMessages;
    }

    private static String convertAnalysisGroupAndNameToKey(MetricSchemaChangeEntry metricEntry) {
        return metricEntry.getAnalysisGroup() + ":" + metricEntry.getMetricDirectoryEntry().getName();
    }

    private static Set<String> getNamesInMetricAnalysisGroup(MetricSchemaChangeEntry metric, Map<String, Set<String>> metricDefinitionNames) {
        String analysisGroupName = metric.getAnalysisGroup();
        metricDefinitionNames.putIfAbsent(analysisGroupName, new HashSet());
        return metricDefinitionNames.get(analysisGroupName);
    }

    private static Set<String> validateUniqueMetricIds(List<MetricSchemaChangeEntry> metricEntries) {
        HashSet<String> errorMessages = new HashSet<String>();
        HashSet<String> uniqueMetricIds = new HashSet<String>();
        for (MetricSchemaChangeEntry metricEntry : metricEntries) {
            if (uniqueMetricIds.contains(metricEntry.getMetricId())) {
                errorMessages.add("Metric id \"" + metricEntry.getMetricId() + "\" is not unique.");
                continue;
            }
            uniqueMetricIds.add(metricEntry.getMetricId());
        }
        return errorMessages;
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains(EAnalysisTool.CUSTOM_METRICS)) {
            return;
        }
        template.registerConfiguration((AnalysisConfigurationBase)this);
        Map<String, List<MetricSchemaChangeEntry>> byGroupMap = this.entries.stream().collect(Collectors.groupingBy(MetricSchemaChangeEntry::getAnalysisGroup));
        for (Map.Entry<String, List<MetricSchemaChangeEntry>> mapEntry : byGroupMap.entrySet()) {
            String groupName = mapEntry.getKey();
            ArrayList<MetricDescriptor> items = new ArrayList<MetricDescriptor>();
            for (MetricSchemaChangeEntry metricSchemaChangeEntry : mapEntry.getValue()) {
                MetricDescriptor descriptor = new MetricDescriptor(metricSchemaChangeEntry.getMetricDirectoryEntry().getName(), metricSchemaChangeEntry.getMetricDirectoryEntry().getDescription());
                this.addMetricDescriptor(descriptor, template.getCodeScope());
                items.add(descriptor);
            }
            template.registerConfigurationItems(groupName, CUSTOM_METRICS_QUALITY_INDICATOR, items);
        }
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        MetricSchemaProxy schema = proxy.getCodeMetricSchema();
        Map<String, List<MetricDescriptor>> metricsByName = this.getProvidedMetrics(CodeScopeAware.DEFAULT_CODE_SCOPE).stream().collect(Collectors.groupingBy(ConfigurationItemBase::getName));
        for (MetricSchemaChangeEntry metricSchemaChangeEntry : this.entries) {
            if (!metricsByName.get(metricSchemaChangeEntry.getMetricDirectoryEntry().getName()).get(0).isMetricEnabled()) continue;
            MetricDirectorySchemaEntry directoryEntry = metricSchemaChangeEntry.getMetricDirectoryEntry();
            schema.addMetric(metricSchemaChangeEntry.getMetricId(), (IMetricSource)new IndexMetricSource(metricSchemaChangeEntry.getMetricId()), directoryEntry.getName(), directoryEntry.getDescription(), directoryEntry.getValueType(), directoryEntry.getAggregation(), (EMetricProperty[])CollectionUtils.toArray((Collection)directoryEntry.getProperties(), EMetricProperty.class));
        }
        proxy.createTrigger(new TriggerBuilder(ExternalMetricsSynchronizer.class, ETriggerConcurrency.PARALLEL).setCost(ETriggerCost.CHEAP));
    }
}

