/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.google.common.collect.Sets;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.index.configuration.tools.message.MypyMessageManager;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class MypyConfiguration
extends ToolConfigurationBase {
    public MypyConfiguration() {
        super(EAnalysisTool.MYPY, "Mypy", "Python");
        this.declareCodeScopeAware();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.registerFindings(template.getCodeScope());
        super.registerQualityIndicators(template, languages, tools);
    }

    private void registerFindings(CodeScopeName codeScope) {
        MypyMessageManager messageManager = MypyMessageManager.getInstance();
        for (MypyMessageManager.MypyRule mypyRule : messageManager.getMypyRules()) {
            String findingsGroupName = messageManager.getFindingsGroupNameFor(mypyRule.errorCode);
            CCSMAssert.isNotNull((Object)findingsGroupName);
            FindingDescriptor descriptor = new FindingDescriptor(mypyRule.errorName, EAnalysisTool.MYPY, (Set)Sets.newHashSet((Object[])new ELanguage[]{ELanguage.PYTHON}), mypyRule.defaultEnablement, mypyRule.errorName);
            String analysisGroupName = this.getGroup("Mypy");
            this.registerFinding(descriptor, analysisGroupName, findingsGroupName, codeScope);
        }
    }
}

